/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MultiReleaseMemCopy {
    private MultiReleaseMemCopy() {
    }

    static void copy(long src, long dst, long bytes) {
        if (bytes < 64L && ((int)src & 7) == 0 && ((int)dst & 7) == 0) {
            if (Pointer.BITS64) {
                MemoryUtil.memCopyAligned64(src, dst, (int)bytes & 0x3F);
            } else {
                MemoryUtil.memCopyAligned32((int)src, (int)dst, (int)bytes & 0x3F);
            }
        } else {
            MemoryUtil.UNSAFE.copyMemory(src, dst, bytes);
        }
    }

    static {
        APIUtil.apiLog("Java 10 memcpy enabled");
    }
}

