/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class IndexFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "INDEX";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2 || parameterCount > 4) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        ArrayCallback arrayCallback = context.getTypeRegistry().convertToArray(parameters.getType(0), parameters.getValue(0));
        if (arrayCallback == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Type rowType = parameters.getType(1);
        Object rowValue = parameters.getValue(1);
        Number rowNumber = rowValue == null ? (Number)null : (Number)context.getTypeRegistry().convertToNumber(rowType, rowValue);
        if (rowNumber == null) {
            rowNumber = new BigDecimal(1);
        } else if (rowNumber.intValue() <= 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (parameterCount == 3) {
            Type columnType = parameters.getType(2);
            Object columnValue = parameters.getValue(2);
            Number columnNumber = columnValue == null ? (Number)null : (Number)context.getTypeRegistry().convertToNumber(columnType, columnValue);
            if (columnNumber == null) {
                columnNumber = new BigDecimal(1);
            } else if (columnNumber.intValue() <= 0) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            return new TypeValuePair(AnyType.TYPE, arrayCallback.getValue(rowNumber.intValue() - 1, columnNumber.intValue() - 1));
        }
        return new TypeValuePair(AnyType.TYPE, arrayCallback.getValue(rowNumber.intValue() - 1, 0));
    }
}

