/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public class SessionExpiration {
    public static void setClientSessionExpiration(MapAuthenticatedClientSessionEntity entity, RealmModel realm, ClientModel client) {
        long timestampMillis;
        long l = timestampMillis = entity.getTimestamp() != null ? entity.getTimestamp() : 0L;
        if (Boolean.TRUE.equals(entity.isOffline())) {
            long sessionExpires = timestampMillis + TimeAdapter.fromSecondsToMilliseconds(realm.getOfflineSessionIdleTimeout());
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                sessionExpires = timestampMillis + TimeAdapter.fromSecondsToMilliseconds(realm.getOfflineSessionMaxLifespan());
                String clientOfflineSessionMaxLifespanPerClient = client.getAttribute("client.offline.session.max.lifespan");
                long clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespanPerClient != null && !clientOfflineSessionMaxLifespanPerClient.trim().isEmpty() ? TimeAdapter.fromSecondsToMilliseconds(Long.parseLong(clientOfflineSessionMaxLifespanPerClient)).longValue() : TimeAdapter.fromSecondsToMilliseconds(realm.getClientOfflineSessionMaxLifespan()).longValue();
                if (clientOfflineSessionMaxLifespan > 0L) {
                    long clientOfflineSessionMaxExpiration = timestampMillis + clientOfflineSessionMaxLifespan;
                    sessionExpires = Math.min(sessionExpires, clientOfflineSessionMaxExpiration);
                }
            }
            long expiration = timestampMillis + TimeAdapter.fromSecondsToMilliseconds(realm.getOfflineSessionIdleTimeout());
            String clientOfflineSessionIdleTimeoutPerClient = client.getAttribute("client.offline.session.idle.timeout");
            long clientOfflineSessionIdleTimeout = clientOfflineSessionIdleTimeoutPerClient != null && !clientOfflineSessionIdleTimeoutPerClient.trim().isEmpty() ? TimeAdapter.fromSecondsToMilliseconds(Long.parseLong(clientOfflineSessionIdleTimeoutPerClient)).longValue() : TimeAdapter.fromSecondsToMilliseconds(realm.getClientOfflineSessionIdleTimeout()).longValue();
            if (clientOfflineSessionIdleTimeout > 0L) {
                long clientOfflineSessionIdleExpiration = timestampMillis + clientOfflineSessionIdleTimeout;
                expiration = Math.min(expiration, clientOfflineSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        } else {
            long sessionExpires = timestampMillis + (realm.getSsoSessionMaxLifespanRememberMe() > 0 ? TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionMaxLifespanRememberMe()) : TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionMaxLifespan()));
            String clientSessionMaxLifespanPerClient = client.getAttribute("client.session.max.lifespan");
            long clientSessionMaxLifespan = clientSessionMaxLifespanPerClient != null && !clientSessionMaxLifespanPerClient.trim().isEmpty() ? TimeAdapter.fromSecondsToMilliseconds(Long.parseLong(clientSessionMaxLifespanPerClient)).longValue() : TimeAdapter.fromSecondsToMilliseconds(realm.getClientSessionMaxLifespan()).longValue();
            if (clientSessionMaxLifespan > 0L) {
                long clientSessionMaxExpiration = timestampMillis + clientSessionMaxLifespan;
                sessionExpires = Math.min(sessionExpires, clientSessionMaxExpiration);
            }
            long expiration = timestampMillis + (realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionIdleTimeoutRememberMe()) : TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionIdleTimeout()));
            String clientSessionIdleTimeoutPerClient = client.getAttribute("client.session.idle.timeout");
            long clientSessionIdleTimeout = clientSessionIdleTimeoutPerClient != null && !clientSessionIdleTimeoutPerClient.trim().isEmpty() ? TimeAdapter.fromSecondsToMilliseconds(Long.parseLong(clientSessionIdleTimeoutPerClient)).longValue() : TimeAdapter.fromSecondsToMilliseconds(realm.getClientSessionIdleTimeout()).longValue();
            if (clientSessionIdleTimeout > 0L) {
                long clientSessionIdleExpiration = timestampMillis + clientSessionIdleTimeout;
                expiration = Math.min(expiration, clientSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        }
    }

    public static void setUserSessionExpiration(MapUserSessionEntity entity, RealmModel realm) {
        long lastSessionRefreshMillis;
        long timestampMillis = entity.getTimestamp() != null ? entity.getTimestamp() : 0L;
        long l = lastSessionRefreshMillis = entity.getLastSessionRefresh() != null ? entity.getLastSessionRefresh() : 0L;
        if (Boolean.TRUE.equals(entity.isOffline())) {
            long sessionExpires = lastSessionRefreshMillis + TimeAdapter.fromSecondsToMilliseconds(realm.getOfflineSessionIdleTimeout());
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                sessionExpires = timestampMillis + TimeAdapter.fromSecondsToMilliseconds(realm.getOfflineSessionMaxLifespan());
                long clientOfflineSessionMaxLifespan = TimeAdapter.fromSecondsToMilliseconds(realm.getClientOfflineSessionMaxLifespan());
                if (clientOfflineSessionMaxLifespan > 0L) {
                    long clientOfflineSessionMaxExpiration = timestampMillis + clientOfflineSessionMaxLifespan;
                    sessionExpires = Math.min(sessionExpires, clientOfflineSessionMaxExpiration);
                }
            }
            long expiration = lastSessionRefreshMillis + TimeAdapter.fromSecondsToMilliseconds(realm.getOfflineSessionIdleTimeout());
            long clientOfflineSessionIdleTimeout = TimeAdapter.fromSecondsToMilliseconds(realm.getClientOfflineSessionIdleTimeout());
            if (clientOfflineSessionIdleTimeout > 0L) {
                long clientOfflineSessionIdleExpiration = Time.currentTimeMillis() + clientOfflineSessionIdleTimeout;
                expiration = Math.min(expiration, clientOfflineSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        } else {
            long sessionExpires = timestampMillis + (Boolean.TRUE.equals(entity.isRememberMe()) && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionMaxLifespanRememberMe()) : TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionMaxLifespan()));
            long clientSessionMaxLifespan = TimeAdapter.fromSecondsToMilliseconds(realm.getClientSessionMaxLifespan());
            if (clientSessionMaxLifespan > 0L) {
                long clientSessionMaxExpiration = timestampMillis + clientSessionMaxLifespan;
                sessionExpires = Math.min(sessionExpires, clientSessionMaxExpiration);
            }
            long expiration = lastSessionRefreshMillis + (Boolean.TRUE.equals(entity.isRememberMe()) && realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionIdleTimeoutRememberMe()) : TimeAdapter.fromSecondsToMilliseconds(realm.getSsoSessionIdleTimeout()));
            long clientSessionIdleTimeout = TimeAdapter.fromSecondsToMilliseconds(realm.getClientSessionIdleTimeout());
            if (clientSessionIdleTimeout > 0L) {
                long clientSessionIdleExpiration = lastSessionRefreshMillis + clientSessionIdleTimeout;
                expiration = Math.min(expiration, clientSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        }
    }
}

