/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.net.URL;
import java.util.List;
import org.testcontainers.shaded.com.google.common.base.Charsets;
import org.testcontainers.shaded.com.google.common.io.Resources;

public final class LicenseAcceptance {
    private static final String ACCEPTANCE_FILE_NAME = "container-license-acceptance.txt";

    public static void assertLicenseAccepted(String imageName) {
        try {
            URL url = Resources.getResource(ACCEPTANCE_FILE_NAME);
            List<String> acceptedLicences = Resources.readLines(url, Charsets.UTF_8);
            if (acceptedLicences.stream().map(String::trim).anyMatch(imageName::equals)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalStateException("The image " + imageName + " requires you to accept a license agreement. Please place a file at the root of the classpath named " + ACCEPTANCE_FILE_NAME + ", e.g. at src/test/resources/" + ACCEPTANCE_FILE_NAME + ". This file should contain the line:\n  " + imageName);
    }

    private LicenseAcceptance() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

