/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.CompletionHandler;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.alias.Alias;
import org.jboss.aesh.console.alias.AliasManager;
import org.jboss.aesh.console.operator.ControlOperatorParser;
import org.jboss.aesh.console.operator.RedirectionCompletion;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.PrevWordAction;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.aesh.util.LoggerUtil;

public class AeshCompletionHandler
implements CompletionHandler {
    private final boolean operatorParserEnabled;
    private volatile boolean enabled = true;
    private final AeshContext aeshContext;
    private boolean askDisplayCompletion = false;
    private int displayCompletionSize = 100;
    private final List<Completion> completionList = new ArrayList<Completion>();
    private AliasManager aliasManager;
    private final ConsoleBuffer consoleBuffer;
    private final Shell shell;
    private final boolean doLogging;
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshCompletionHandler.class.getName());

    public AeshCompletionHandler(AeshContext aeshContext, ConsoleBuffer consoleBuffer, Shell shell, boolean operatorParserEnabled, boolean doLogging) {
        this.aeshContext = aeshContext;
        this.consoleBuffer = consoleBuffer;
        this.shell = shell;
        this.operatorParserEnabled = operatorParserEnabled;
        this.doLogging = doLogging;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void addCompletion(Completion completion) {
        this.completionList.add(completion);
    }

    @Override
    public void removeCompletion(Completion completion) {
        this.completionList.remove(completion);
    }

    @Override
    public boolean doAskDisplayCompletion() {
        return this.askDisplayCompletion;
    }

    @Override
    public void setAskDisplayCompletion(boolean askDisplayCompletion) {
        this.askDisplayCompletion = askDisplayCompletion;
    }

    @Override
    public void setAskCompletionSize(int size) {
        this.displayCompletionSize = size;
    }

    @Override
    public int getAskCompletionSize() {
        return this.displayCompletionSize;
    }

    @Override
    public void setAliasManager(AliasManager aliasManager) {
        this.aliasManager = aliasManager;
    }

    @Override
    public void complete(PrintStream out, Buffer buffer) throws IOException {
        if (!this.enabled) {
            return;
        }
        if (this.completionList.size() < 1) {
            return;
        }
        ArrayList<CompleteOperation> possibleCompletions = new ArrayList<CompleteOperation>();
        int pipeLinePos = 0;
        boolean redirect = false;
        if (this.operatorParserEnabled && ControlOperatorParser.doStringContainPipelineOrEnd(buffer.getMultiLine())) {
            pipeLinePos = ControlOperatorParser.findLastPipelineAndEndPositionBeforeCursor(buffer.getMultiLine(), buffer.getMultiCursor());
        }
        if (this.operatorParserEnabled && ControlOperatorParser.findLastRedirectionPositionBeforeCursor(buffer.getMultiLine(), buffer.getMultiCursor()) > pipeLinePos) {
            pipeLinePos = 0;
            redirect = true;
        }
        for (int i = 0; i < this.completionList.size() && (!redirect || this.completionList.get(i).getClass().equals(RedirectionCompletion.class)); ++i) {
            CompleteOperation co = pipeLinePos > 0 ? this.findAliases(buffer.getMultiLine().substring(pipeLinePos, buffer.getMultiCursor()), buffer.getMultiCursor() - pipeLinePos) : this.findAliases(buffer.getMultiLine(), buffer.getMultiCursor());
            this.completionList.get(i).complete(co);
            if (co.getCompletionCandidates() == null || co.getCompletionCandidates().size() <= 0) continue;
            possibleCompletions.add(co);
        }
        if (this.doLogging) {
            LOGGER.info("Found completions: " + possibleCompletions);
        }
        if (possibleCompletions.size() != 0) {
            if (possibleCompletions.size() == 1 && ((CompleteOperation)possibleCompletions.get(0)).getCompletionCandidates().size() == 1) {
                this.displayCompletion(((CompleteOperation)possibleCompletions.get(0)).getFormattedCompletionCandidatesTerminalString().get(0), buffer, out, ((CompleteOperation)possibleCompletions.get(0)).hasAppendSeparator(), ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
            } else {
                String startsWith = "";
                if (!((CompleteOperation)possibleCompletions.get(0)).isIgnoreStartsWith()) {
                    startsWith = Parser.findStartsWithOperation(possibleCompletions);
                }
                if (startsWith.length() > 0) {
                    if (startsWith.contains(" ") && !((CompleteOperation)possibleCompletions.get(0)).doIgnoreNonEscapedSpace()) {
                        this.displayCompletion(new TerminalString(Parser.switchSpacesToEscapedSpacesInWord(startsWith), true), buffer, out, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
                    } else {
                        this.displayCompletion(new TerminalString(startsWith, true), buffer, out, false, ((CompleteOperation)possibleCompletions.get(0)).getSeparator());
                    }
                } else {
                    ArrayList<TerminalString> completions = new ArrayList<TerminalString>();
                    for (int i = 0; i < possibleCompletions.size(); ++i) {
                        completions.addAll(((CompleteOperation)possibleCompletions.get(i)).getCompletionCandidates());
                    }
                    if (completions.size() > 100) {
                        if (this.askDisplayCompletion) {
                            this.displayCompletions(completions, buffer, out);
                            this.askDisplayCompletion = false;
                        } else {
                            this.askDisplayCompletion = true;
                            out.print(Config.getLineSeparator() + "Display all " + completions.size() + " possibilities? (y or n)");
                        }
                    } else {
                        this.displayCompletions(completions, buffer, out);
                    }
                }
            }
        }
    }

    private void displayCompletion(TerminalString completion, Buffer buffer, PrintStream out, boolean appendSpace, char separator) throws IOException {
        if (completion.getCharacters().startsWith(buffer.getMultiLine())) {
            this.consoleBuffer.performAction(new PrevWordAction(buffer.getMultiCursor(), Action.DELETE, Mode.EMACS));
            buffer.write(completion.getCharacters());
            out.print(completion);
        } else {
            buffer.write(completion.getCharacters());
            out.print(completion);
        }
        if (appendSpace) {
            buffer.write(separator);
            out.print(separator);
        }
        this.consoleBuffer.drawLine();
    }

    private void displayCompletions(List<TerminalString> completions, Buffer buffer, PrintStream out) throws IOException {
        Collections.sort(completions);
        int oldCursorPos = buffer.getCursor();
        out.print(Config.getLineSeparator());
        buffer.setCursor(oldCursorPos);
        out.print(Parser.formatDisplayListTerminalString(completions, this.shell.getSize().getHeight(), this.shell.getSize().getWidth()));
        this.consoleBuffer.displayPrompt();
        out.print(buffer.getLine());
        out.flush();
        this.consoleBuffer.syncCursor();
    }

    private CompleteOperation findAliases(String buffer, int cursor) {
        String command;
        Alias alias;
        if (this.aliasManager != null && (alias = this.aliasManager.getAlias(command = Parser.findFirstWord(buffer))) != null) {
            return new CompleteOperation(this.aeshContext, alias.getValue() + buffer.substring(command.length()), cursor + (alias.getValue().length() - command.length()));
        }
        return new CompleteOperation(this.aeshContext, buffer, cursor);
    }
}

