/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.inject.spi.DefinitionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class DisposerInfo
implements InjectionTargetInfo {
    private final BeanInfo declaringBean;
    private final MethodInfo disposerMethod;
    private final Injection injection;
    private final MethodParameterInfo disposedParameter;

    DisposerInfo(BeanInfo declaringBean, MethodInfo disposerMethod, Injection injection) {
        this.declaringBean = declaringBean;
        this.disposerMethod = disposerMethod;
        this.injection = injection;
        this.disposedParameter = this.initDisposedParam(disposerMethod);
    }

    @Override
    public InjectionTargetInfo.TargetKind kind() {
        return InjectionTargetInfo.TargetKind.DISPOSER;
    }

    @Override
    public DisposerInfo asDisposer() {
        return this;
    }

    public BeanInfo getDeclaringBean() {
        return this.declaringBean;
    }

    public MethodInfo getDisposerMethod() {
        return this.disposerMethod;
    }

    public MethodParameterInfo getDisposedParameter() {
        return this.disposedParameter;
    }

    Injection getInjection() {
        return this.injection;
    }

    public List<InjectionPointInfo> getAllInjectionPoints() {
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        injectionPoints.addAll(this.injection.injectionPoints);
        return injectionPoints;
    }

    void init(List<Throwable> errors) {
        for (InjectionPointInfo injectionPoint : this.injection.injectionPoints) {
            Beans.resolveInjectionPoint(this.declaringBean.getDeployment(), this, injectionPoint, errors);
        }
    }

    Collection<AnnotationInstance> getDisposedParameterQualifiers() {
        HashSet<AnnotationInstance> resultingQualifiers = new HashSet<AnnotationInstance>();
        Annotations.getParameterAnnotations(this.declaringBean.getDeployment(), this.disposerMethod, (int)this.disposedParameter.position()).stream().forEach(a -> resultingQualifiers.addAll(this.declaringBean.getDeployment().extractQualifiers((AnnotationInstance)a)));
        return resultingQualifiers;
    }

    Type getDisposedParameterType() {
        return this.disposerMethod.parameterType((int)this.disposedParameter.position());
    }

    MethodParameterInfo initDisposedParam(MethodInfo disposerMethod) {
        ArrayList<MethodParameterInfo> disposedParams = new ArrayList<MethodParameterInfo>();
        for (AnnotationInstance annotation : disposerMethod.annotations()) {
            if (AnnotationTarget.Kind.METHOD_PARAMETER != annotation.target().kind() || !annotation.name().equals((Object)DotNames.DISPOSES)) continue;
            disposedParams.add(annotation.target().asMethodParameter());
        }
        if (disposedParams.isEmpty()) {
            throw new DefinitionException("No disposed parameters found for " + disposerMethod);
        }
        if (disposedParams.size() > 1) {
            throw new DefinitionException("Multiple disposed parameters found for " + disposerMethod);
        }
        return (MethodParameterInfo)disposedParams.get(0);
    }
}

