/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.staticmethods;

import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.util.HashUtil;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;

public final class InterceptedStaticMethodBuildItem
extends MultiBuildItem {
    private final MethodInfo method;
    private final List<InterceptorInfo> interceptors;
    private final Set<AnnotationInstance> bindings;
    private final String hash;

    InterceptedStaticMethodBuildItem(MethodInfo method, Set<AnnotationInstance> bindings, List<InterceptorInfo> interceptors) {
        this.method = method;
        this.interceptors = interceptors;
        this.bindings = bindings;
        this.hash = HashUtil.sha1((String)(method.declaringClass().name().toString() + method.toString()));
    }

    public ClassInfo getTarget() {
        return this.method.declaringClass();
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public List<InterceptorInfo> getInterceptors() {
        return this.interceptors;
    }

    public Set<AnnotationInstance> getBindings() {
        return this.bindings;
    }

    public String getHash() {
        return this.hash;
    }
}

