/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.keycloak.common.util.Base64;

public class BasicAuthHelper {
    public static String createHeader(String username, String password) {
        try {
            return "Basic " + Base64.encodeBytes((username + ':' + password).getBytes(StandardCharsets.UTF_8), 8);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String[] parseHeader(String header) {
        String val;
        if (header.length() < 6) {
            return null;
        }
        String type = header.substring(0, 5);
        if (!(type = type.toLowerCase()).equalsIgnoreCase("Basic")) {
            return null;
        }
        try {
            val = new String(Base64.decode(header.substring(6), 8));
        }
        catch (IOException e) {
            return null;
        }
        int separatorIndex = val.indexOf(":");
        if (separatorIndex == -1) {
            return null;
        }
        String username = val.substring(0, separatorIndex);
        String password = val.substring(separatorIndex + 1);
        return new String[]{username, password};
    }

    public static abstract class RFC6749 {
        public static String createHeader(String username, String password) {
            try {
                return BasicAuthHelper.createHeader(URLEncoder.encode(username, "UTF-8"), URLEncoder.encode(password, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        public static String[] parseHeader(String header) {
            String[] val = BasicAuthHelper.parseHeader(header);
            if (null == val) {
                return null;
            }
            try {
                return new String[]{URLDecoder.decode(val[0], "UTF-8"), URLDecoder.decode(val[1], "UTF-8")};
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }
}

