/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.jitsi.srtp.crypto.SrtpCipher;

public class SrtpCipherF8
extends SrtpCipher {
    private SecretKeySpec encKey;
    private SecretKeySpec maskedKey;
    private F8Context f8ctx;

    public SrtpCipherF8(Cipher cipher) {
        super(cipher);
    }

    @Override
    public void init(byte[] k_e, byte[] k_s) {
        int i;
        if (k_e.length != 16) {
            throw new IllegalArgumentException("k_e.length != BLKLEN");
        }
        if (k_s.length > k_e.length) {
            throw new IllegalArgumentException("k_s.length > k_e.length");
        }
        this.encKey = this.getSecretKey(k_e);
        byte[] k_m = new byte[k_e.length];
        for (i = 0; i < k_s.length; ++i) {
            k_m[i] = (byte)(k_e[i] ^ k_s[i]);
        }
        while (i < k_m.length) {
            k_m[i] = (byte)(k_e[i] ^ 0x55);
            ++i;
        }
        this.maskedKey = this.getSecretKey(k_m);
    }

    @Override
    public void setIV(byte[] iv, int opmode) throws GeneralSecurityException {
        if (iv.length != this.cipher.getBlockSize()) {
            throw new IllegalArgumentException("iv.length != BLKLEN");
        }
        this.f8ctx = new F8Context();
        this.f8ctx.ivAccent = new byte[16];
        this.cipher.init(1, this.maskedKey);
        this.cipher.update(iv, 0, iv.length, this.f8ctx.ivAccent, 0);
        this.cipher.init(1, this.encKey);
        this.f8ctx.J = 0L;
        this.f8ctx.S = new byte[16];
    }

    @Override
    public void processAAD(byte[] data2, int off, int len) {
        throw new IllegalStateException("F8 mode does not accept AAD");
    }

    @Override
    public int process(byte[] data2, int off, int len) throws GeneralSecurityException {
        int inLen = len;
        while (inLen >= 16) {
            this.processBlock(this.f8ctx, data2, off, 16);
            inLen -= 16;
            off += 16;
        }
        if (inLen > 0) {
            this.processBlock(this.f8ctx, data2, off, inLen);
        }
        return len;
    }

    private void processBlock(F8Context f8ctx, byte[] inOut, int off, int len) throws ShortBufferException {
        int i;
        for (i = 0; i < 16; ++i) {
            int n = i;
            f8ctx.S[n] = (byte)(f8ctx.S[n] ^ f8ctx.ivAccent[i]);
        }
        f8ctx.S[12] = (byte)((long)f8ctx.S[12] ^ f8ctx.J >> 24);
        f8ctx.S[13] = (byte)((long)f8ctx.S[13] ^ f8ctx.J >> 16);
        f8ctx.S[14] = (byte)((long)f8ctx.S[14] ^ f8ctx.J >> 8);
        f8ctx.S[15] = (byte)((long)f8ctx.S[15] ^ f8ctx.J);
        ++f8ctx.J;
        this.cipher.update(f8ctx.S, 0, f8ctx.S.length, f8ctx.S, 0);
        for (i = 0; i < len; ++i) {
            int n = off + i;
            inOut[n] = (byte)(inOut[n] ^ f8ctx.S[i]);
        }
    }

    static class F8Context {
        public byte[] S;
        public byte[] ivAccent;
        long J;

        F8Context() {
        }
    }
}

