/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.FilteredMinimalFileTree;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.RandomAccessFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;

public class FileTreeAdapter
extends AbstractFileTree {
    private final MinimalFileTree tree;

    public FileTreeAdapter(MinimalFileTree tree, Factory<PatternSet> patternSetFactory) {
        super(patternSetFactory);
        this.tree = tree;
    }

    public MinimalFileTree getTree() {
        return this.tree;
    }

    @Override
    public String getDisplayName() {
        return this.tree.getDisplayName();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        if (this.tree instanceof Buildable) {
            context.add((Object)this.tree);
        }
    }

    @Override
    public boolean contains(File file) {
        if (this.tree instanceof RandomAccessFileCollection) {
            RandomAccessFileCollection randomAccess = (RandomAccessFileCollection)((Object)this.tree);
            return randomAccess.contains(file);
        }
        if (this.tree instanceof GeneratedSingletonFileTree) {
            return ((GeneratedSingletonFileTree)this.tree).getFileWithoutCreating().equals(file);
        }
        if (this.tree instanceof FileSystemMirroringFileTree) {
            return ((FileSystemMirroringFileTree)this.tree).getMirror().contains(file);
        }
        return super.contains(file);
    }

    @Override
    public FileTreeInternal matching(PatternFilterable patterns) {
        if (this.tree instanceof PatternFilterableFileTree) {
            PatternFilterableFileTree filterableTree = (PatternFilterableFileTree)this.tree;
            return new FileTreeAdapter(filterableTree.filter(patterns), (Factory<PatternSet>)this.patternSetFactory);
        }
        if (this.tree instanceof FileSystemMirroringFileTree) {
            return new FileTreeAdapter(new FilteredMinimalFileTree((PatternSet)patterns, (FileSystemMirroringFileTree)this.tree), (Factory<PatternSet>)this.patternSetFactory);
        }
        throw new UnsupportedOperationException(String.format("Do not know how to filter %s.", this.tree));
    }

    public FileTree visit(FileVisitor visitor) {
        this.tree.visit(visitor);
        return this;
    }

    @Override
    public void visitContentsAsFileTrees(Consumer<FileTreeInternal> visitor) {
        visitor.accept(this);
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.tree.visitStructure(visitor, this);
    }
}

