/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.SQLObjectComboBoxModel;
import ca.sqlpower.architect.swingui.olap.OLAPObjectNameValidator;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.NotNullValidator;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MeasureEditPanel
implements ValidatableDataEntryPanel {
    private final MondrianModel.Measure measure;
    private final JPanel panel;
    private JTextField name;
    private JTextField captionField;
    private JComboBox aggregator;
    private JComboBox columnChooser;
    private JRadioButton columnRadioButton;
    private JTextArea expression;
    private JRadioButton expRadioButton;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();

    public MeasureEditPanel(MondrianModel.Measure measure) throws SQLObjectException {
        this.measure = measure;
        this.handler = new FormValidationHandler(this.status, true);
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.name = new JTextField(measure.getName());
        builder.append("Name", (Component)this.name);
        this.captionField = new JTextField(measure.getCaption());
        builder.append("Caption", (Component)this.captionField);
        String[] rolapAggregates = new String[]{"sum", "count", "min", "max", "avg", "distinct-count"};
        this.aggregator = new JComboBox<String>(rolapAggregates);
        builder.append("Aggregator", this.aggregator);
        if (measure.getAggregator() != null) {
            this.aggregator.setSelectedItem(measure.getAggregator());
        }
        builder.appendSeparator("Value");
        AbstractAction radioButtonsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MeasureEditPanel.this.columnChooser.setEnabled(MeasureEditPanel.this.columnRadioButton.isSelected());
                MeasureEditPanel.this.expression.setEnabled(MeasureEditPanel.this.expRadioButton.isSelected());
                MeasureEditPanel.this.handler.performFormValidation();
            }
        };
        this.columnRadioButton = new JRadioButton();
        this.columnRadioButton.setAction(radioButtonsAction);
        this.columnRadioButton.setText("Use Column");
        this.expRadioButton = new JRadioButton();
        this.expRadioButton.setAction(radioButtonsAction);
        this.expRadioButton.setText("Use Expression");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.columnRadioButton);
        buttonGroup.add(this.expRadioButton);
        builder.append((Component)this.columnRadioButton, 3);
        this.columnChooser = new JComboBox();
        builder.append(this.columnChooser, 3);
        builder.append((Component)this.expRadioButton, 3);
        this.expression = new JTextArea(4, 30);
        builder.append((Component)new JScrollPane(this.expression), 3);
        this.expression.setLineWrap(true);
        MondrianModel.Cube parentCube = (MondrianModel.Cube)measure.getParent();
        SQLTable cubeTable = OLAPUtil.tableForCube(parentCube);
        boolean enableColumns = false;
        if (cubeTable == null) {
            this.columnChooser.addItem("Parent Cube has no table");
        } else if (cubeTable.getColumns().isEmpty()) {
            this.columnChooser.addItem("Parent Cube table has no columns");
        } else {
            this.columnChooser.setModel(new SQLObjectComboBoxModel((SQLObject)cubeTable, SQLColumn.class));
            this.columnRadioButton.doClick();
            for (SQLColumn col : cubeTable.getColumns()) {
                if (!col.getName().equalsIgnoreCase(measure.getColumn())) continue;
                this.columnChooser.setSelectedItem(col);
                break;
            }
            enableColumns = true;
        }
        this.columnChooser.setEnabled(enableColumns);
        this.columnRadioButton.setEnabled(enableColumns);
        MondrianModel.SQL exp = null;
        MondrianModel.MeasureExpression mExp = measure.getMeasureExp();
        if (mExp != null) {
            for (MondrianModel.SQL sql : measure.getMeasureExp().getExpressions()) {
                if (sql.getDialect() == null || !sql.getDialect().equalsIgnoreCase("generic")) continue;
                exp = sql;
            }
            this.expRadioButton.doClick();
        }
        this.expression.setText(exp == null ? "" : exp.getText());
        if (!this.columnRadioButton.isSelected()) {
            this.expRadioButton.doClick();
        }
        OLAPObjectNameValidator validator = new OLAPObjectNameValidator((OLAPObject)measure.getParent(), measure, false);
        this.handler.addValidateObject((JComponent)this.name, (Validator)validator);
        this.handler.addValidateObject((JComponent)this.columnChooser, (Validator)new NotNullValidator("Value column"));
        this.panel = builder.getPanel();
    }

    public boolean applyChanges() {
        this.measure.begin("Modify measure properties");
        this.measure.setName(this.name.getText());
        if (!this.captionField.getText().equals("")) {
            this.measure.setCaption(this.captionField.getText());
        } else {
            this.measure.setCaption(null);
        }
        this.measure.setAggregator((String)this.aggregator.getSelectedItem());
        if (this.expRadioButton.isSelected()) {
            MondrianModel.MeasureExpression mExp = this.measure.getMeasureExp();
            if (mExp == null) {
                mExp = new MondrianModel.MeasureExpression();
                this.measure.setMeasureExp(mExp);
            }
            MondrianModel.SQL exp = null;
            for (MondrianModel.SQL sql : mExp.getExpressions()) {
                if (sql.getDialect() == null || !sql.getDialect().equalsIgnoreCase("generic")) continue;
                exp = sql;
            }
            if (exp == null) {
                exp = new MondrianModel.SQL();
                exp.setDialect("generic");
                mExp.addExpression(exp);
            }
            exp.setText(this.expression.getText());
            this.measure.setColumn(null);
        } else {
            SQLColumn col = (SQLColumn)this.columnChooser.getSelectedItem();
            this.measure.setColumn(col.getName());
            this.measure.setMeasureExp(null);
        }
        this.measure.commit();
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }
}

