/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.afterinvocation;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.AfterInvocationManager;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.afterinvocation.AfterInvocationProvider;
import org.springframework.util.Assert;

public class AfterInvocationProviderManager
implements AfterInvocationManager,
InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$afterinvocation$AfterInvocationProviderManager == null ? (class$org$springframework$security$afterinvocation$AfterInvocationProviderManager = AfterInvocationProviderManager.class$("org.springframework.security.afterinvocation.AfterInvocationProviderManager")) : class$org$springframework$security$afterinvocation$AfterInvocationProviderManager));
    private List providers;
    static /* synthetic */ Class class$org$springframework$security$afterinvocation$AfterInvocationProviderManager;
    static /* synthetic */ Class class$org$springframework$security$afterinvocation$AfterInvocationProvider;

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.providers);
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AfterInvocationProviders is required");
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = this.providers.iterator();
        Object result = returnedObject;
        while (iter.hasNext()) {
            AfterInvocationProvider provider = (AfterInvocationProvider)iter.next();
            result = provider.decide(authentication, object, config, result);
        }
        return result;
    }

    public List getProviders() {
        return this.providers;
    }

    public void setProviders(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = iter.next();
            Assert.isInstanceOf((Class)(class$org$springframework$security$afterinvocation$AfterInvocationProvider == null ? AfterInvocationProviderManager.class$("org.springframework.security.afterinvocation.AfterInvocationProvider") : class$org$springframework$security$afterinvocation$AfterInvocationProvider), currentObject, (String)("AfterInvocationProvider " + currentObject.getClass().getName() + " must implement AfterInvocationProvider"));
        }
        this.providers = newList;
    }

    public boolean supports(ConfigAttribute attribute) {
        Iterator iter = this.providers.iterator();
        while (iter.hasNext()) {
            AfterInvocationProvider provider = (AfterInvocationProvider)iter.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Evaluating " + attribute + " against " + provider));
            }
            if (!provider.supports(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Class clazz) {
        Iterator iter = this.providers.iterator();
        while (iter.hasNext()) {
            AfterInvocationProvider provider = (AfterInvocationProvider)iter.next();
            if (provider.supports(clazz)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

