/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.json;

import ca.sqlpower.dao.MessageSender;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.util.SQLPowerUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class SPJSONPersister
implements SPPersister {
    private static final Logger logger = Logger.getLogger(SPJSONPersister.class);
    private int transactionCount = 0;
    private final MessageSender<JSONObject> messageSender;
    private final List<JSONObject> messageBuffer;

    public SPJSONPersister(MessageSender<JSONObject> messageSender) {
        this.messageSender = messageSender;
        this.messageBuffer = new ArrayList<JSONObject>();
    }

    @Override
    public void begin() throws SPPersistenceException {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("method", (Object)SPPersister.SPPersistMethod.begin);
            jsonObject.put("uuid", JSONObject.NULL);
        }
        catch (JSONException e) {
            logger.error((Object)"Exception encountered while building JSON message. Rollback initiated.", (Throwable)e);
            this.rollback();
            throw new SPPersistenceException(null, e);
        }
        logger.debug((Object)jsonObject);
        this.messageBuffer.add(jsonObject);
        ++this.transactionCount;
    }

    @Override
    public void commit() throws SPPersistenceException {
        if (this.transactionCount == 0) {
            throw new SPPersistenceException(null, "Commit attempted while not in a transaction");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("method", (Object)SPPersister.SPPersistMethod.commit);
            jsonObject.put("uuid", JSONObject.NULL);
        }
        catch (JSONException e) {
            logger.error((Object)"Exception encountered while building JSON message. Rollback initiated.", (Throwable)e);
            this.rollback();
            throw new SPPersistenceException(null, e);
        }
        try {
            logger.debug((Object)jsonObject);
            this.messageBuffer.add(jsonObject);
            if (this.transactionCount == 1) {
                for (JSONObject obj : this.messageBuffer) {
                    this.messageSender.send(obj);
                }
                this.messageSender.flush();
                this.messageBuffer.clear();
                this.transactionCount = 0;
            } else {
                --this.transactionCount;
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Exception encountered while building JSON message. Rollback initiated.", t);
            this.messageBuffer.clear();
            this.messageSender.clear();
            this.transactionCount = 0;
            this.rollback();
            if (t instanceof SPPersistenceException) {
                throw (SPPersistenceException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        if (this.transactionCount == 0) {
            throw new SPPersistenceException("Operation attempted while not in a transaction.");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("method", SPPersister.SPPersistMethod.persistObject.toString());
            if (parentUUID == null) {
                jsonObject.put("parentUUID", JSONObject.NULL);
            } else {
                jsonObject.put("parentUUID", parentUUID);
            }
            jsonObject.put("type", type);
            jsonObject.put("uuid", uuid);
            jsonObject.put("index", index);
        }
        catch (JSONException e) {
            logger.error((Object)e);
            this.rollback();
            throw new SPPersistenceException(uuid, e);
        }
        logger.debug((Object)jsonObject);
        this.messageBuffer.add(jsonObject);
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType type, Object oldValue, Object newValue) throws SPPersistenceException {
        if (this.transactionCount == 0) {
            throw new SPPersistenceException("Operation attempted while not in a transaction.");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("method", (Object)SPPersister.SPPersistMethod.changeProperty);
            jsonObject.put("uuid", uuid);
            jsonObject.put("propertyName", propertyName);
            jsonObject.put("type", type.toString());
            this.setValueInJSONObject(jsonObject, "oldValue", type, oldValue);
            this.setValueInJSONObject(jsonObject, "newValue", type, newValue);
        }
        catch (JSONException e) {
            logger.error((Object)e);
            this.rollback();
            throw new SPPersistenceException(uuid, e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            this.rollback();
            throw new SPPersistenceException(uuid, e);
        }
        logger.debug((Object)jsonObject);
        this.messageBuffer.add(jsonObject);
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType type, Object newValue) throws SPPersistenceException {
        if (this.transactionCount == 0) {
            throw new SPPersistenceException("Operation attempted while not in a transaction.");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("method", (Object)SPPersister.SPPersistMethod.persistProperty);
            jsonObject.put("uuid", uuid);
            jsonObject.put("propertyName", propertyName);
            jsonObject.put("type", type.toString());
            this.setValueInJSONObject(jsonObject, "newValue", type, newValue);
        }
        catch (JSONException e) {
            logger.error((Object)e);
            this.rollback();
            throw new SPPersistenceException(uuid, e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            this.rollback();
            throw new SPPersistenceException(uuid, e);
        }
        logger.debug((Object)jsonObject);
        this.messageBuffer.add(jsonObject);
    }

    private void setValueInJSONObject(JSONObject jsonObject, String jsonPropName, SPPersister.DataType type, Object value) throws IOException, JSONException, UnsupportedEncodingException {
        if (type == SPPersister.DataType.PNG_IMG && value != null) {
            InputStream in = (InputStream)value;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SQLPowerUtils.copyStream(in, out);
            byte[] bytes = out.toByteArray();
            byte[] base64Bytes = Base64.encodeBase64((byte[])bytes);
            jsonObject.put(jsonPropName, new String(base64Bytes, "ascii"));
        } else {
            jsonObject.put(jsonPropName, value == null ? JSONObject.NULL : value);
        }
    }

    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
        if (this.transactionCount == 0) {
            throw new SPPersistenceException("Operation attempted while not in a transaction.");
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("method", (Object)SPPersister.SPPersistMethod.removeObject);
            jsonObject.put("parentUUID", parentUUID);
            jsonObject.put("uuid", uuid);
        }
        catch (JSONException e) {
            logger.error((Object)e);
            this.rollback();
            throw new SPPersistenceException(uuid, e);
        }
        logger.debug((Object)jsonObject);
        this.messageBuffer.add(jsonObject);
    }

    @Override
    public void rollback() {
        this.messageBuffer.clear();
        this.messageSender.clear();
        this.transactionCount = 0;
    }

    public MessageSender<JSONObject> getMessageSender() {
        return this.messageSender;
    }
}

