/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import org.jetbrains.annotations.NotNull;

public class NewArrayNode
extends InsnNode {
    private final ArgType arrType;

    public NewArrayNode(@NotNull ArgType arrType, RegisterArg res, InsnArg size) {
        this(arrType);
        this.setResult(res);
        this.addArg(size);
    }

    private NewArrayNode(ArgType arrType) {
        super(InsnType.NEW_ARRAY, 1);
        this.arrType = arrType;
    }

    public ArgType getArrayType() {
        return this.arrType;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NewArrayNode) || !super.isSame(obj)) {
            return false;
        }
        NewArrayNode other = (NewArrayNode)obj;
        return this.arrType == other.arrType;
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new NewArrayNode(this.arrType));
    }

    @Override
    public String toString() {
        return super.toString() + " type: " + this.arrType;
    }
}

