"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.config = {
    width: 500,
    height: 500,
    margin: { left: 0.01, right: 0.01, top: 0.01, bottom: 0.01 },
    maxRowHeight: 30,
    maxColumnWidth: 30,
    fontFamily: 'Sans-Serif',
    onBrushEnd: undefined,
    brushArea: {
        visible: true,
        fill: 'black',
        stroke: '#69707D',
        strokeWidth: 2,
    },
    brushMask: {
        visible: true,
        fill: 'rgb(115 115 115 / 50%)',
    },
    brushTool: {
        visible: false,
        fill: 'gray',
    },
    timeZone: 'UTC',
    xAxisLabel: {
        name: 'X Value',
        visible: true,
        fill: 'black',
        fontSize: 12,
        fontFamily: 'Sans-Serif',
        fontStyle: 'normal',
        textColor: 'black',
        fontVariant: 'normal',
        fontWeight: 'normal',
        textOpacity: 1,
        align: 'center',
        baseline: 'verticalAlign',
        padding: 6,
        formatter: String,
    },
    yAxisLabel: {
        name: 'Y Value',
        visible: true,
        width: 'auto',
        fill: 'black',
        fontSize: 12,
        fontFamily: 'Sans-Serif',
        fontStyle: 'normal',
        textColor: 'black',
        fontVariant: 'normal',
        fontWeight: 'normal',
        textOpacity: 1,
        baseline: 'verticalAlign',
        padding: 5,
        formatter: String,
    },
    grid: {
        cellWidth: {
            min: 0,
            max: 30,
        },
        cellHeight: {
            min: 12,
            max: 30,
        },
        stroke: {
            width: 1,
            color: 'gray',
        },
    },
    cell: {
        maxWidth: 'fill',
        maxHeight: 'fill',
        align: 'center',
        label: {
            visible: true,
            maxWidth: 'fill',
            fill: 'black',
            fontSize: 10,
            fontFamily: 'Sans-Serif',
            fontStyle: 'normal',
            textColor: 'black',
            fontVariant: 'normal',
            fontWeight: 'normal',
            textOpacity: 1,
            align: 'center',
            baseline: 'verticalAlign',
        },
        border: {
            strokeWidth: 1,
            stroke: 'gray',
        },
    },
};
//# sourceMappingURL=config.js.map