/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.parameters;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final ParameterNameFactory<Constructor<?>> CONSTRUCTOR_METHODPARAM_FACTORY = constructor -> constructor.getParameterAnnotations();
    private static final ParameterNameFactory<Method> METHOD_METHODPARAM_FACTORY = Method::getParameterAnnotations;
    private final Set<String> annotationClassesToUse;

    public AnnotationParameterNameDiscoverer(String ... annotationClassToUse) {
        this(new HashSet<String>(Arrays.asList(annotationClassToUse)));
    }

    public AnnotationParameterNameDiscoverer(Set<String> annotationClassesToUse) {
        Assert.notEmpty(annotationClassesToUse, "annotationClassesToUse cannot be null or empty");
        this.annotationClassesToUse = annotationClassesToUse;
    }

    @Override
    public String[] getParameterNames(Method method) {
        Class<?>[] interfaces;
        Method originalMethod = BridgeMethodResolver.findBridgedMethod(method);
        String[] paramNames = this.lookupParameterNames(METHOD_METHODPARAM_FACTORY, originalMethod);
        if (paramNames != null) {
            return paramNames;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> intrfc : interfaces = declaringClass.getInterfaces()) {
            Method intrfcMethod = ReflectionUtils.findMethod(intrfc, method.getName(), method.getParameterTypes());
            if (intrfcMethod == null) continue;
            return this.lookupParameterNames(METHOD_METHODPARAM_FACTORY, intrfcMethod);
        }
        return paramNames;
    }

    @Override
    public String[] getParameterNames(Constructor<?> constructor) {
        return this.lookupParameterNames(CONSTRUCTOR_METHODPARAM_FACTORY, constructor);
    }

    private <T extends AccessibleObject> String[] lookupParameterNames(ParameterNameFactory<T> parameterNameFactory, T t) {
        Annotation[][] parameterAnnotations = parameterNameFactory.findParameterAnnotations(t);
        int parameterCount = parameterAnnotations.length;
        String[] paramNames = new String[parameterCount];
        boolean found = false;
        for (int i = 0; i < parameterCount; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            String parameterName = this.findParameterName(annotations);
            if (parameterName == null) continue;
            found = true;
            paramNames[i] = parameterName;
        }
        return found ? paramNames : null;
    }

    private String findParameterName(Annotation[] parameterAnnotations) {
        for (Annotation paramAnnotation : parameterAnnotations) {
            if (!this.annotationClassesToUse.contains(paramAnnotation.annotationType().getName())) continue;
            return (String)AnnotationUtils.getValue(paramAnnotation, "value");
        }
        return null;
    }

    @FunctionalInterface
    private static interface ParameterNameFactory<T extends AccessibleObject> {
        public Annotation[][] findParameterAnnotations(T var1);
    }
}

