/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.slf4j;

import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

class Slf4jLocationAwareLoggerImpl
implements Log {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"MYBATIS");
    private static final String FQCN = Slf4jImpl.class.getName();
    private final LocationAwareLogger logger;

    Slf4jLocationAwareLoggerImpl(LocationAwareLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void error(String s2, Throwable e) {
        this.logger.log(MARKER, FQCN, 40, s2, null, e);
    }

    @Override
    public void error(String s2) {
        this.logger.log(MARKER, FQCN, 40, s2, null, null);
    }

    @Override
    public void debug(String s2) {
        this.logger.log(MARKER, FQCN, 10, s2, null, null);
    }

    @Override
    public void trace(String s2) {
        this.logger.log(MARKER, FQCN, 0, s2, null, null);
    }

    @Override
    public void warn(String s2) {
        this.logger.log(MARKER, FQCN, 30, s2, null, null);
    }
}

