/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.builder.xml;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NewRuleAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.area.XlsArea;
import org.jxls.builder.AreaBuilder;
import org.jxls.builder.xml.AreaAction;
import org.jxls.builder.xml.EachAction;
import org.jxls.builder.xml.GridAction;
import org.jxls.builder.xml.IfAction;
import org.jxls.builder.xml.SimpleConfigurator;
import org.jxls.builder.xml.UserCommandAction;
import org.jxls.transform.Transformer;

public class XmlAreaBuilder
implements AreaBuilder {
    private Transformer transformer;
    private InputStream xmlInputStream;
    private boolean clearTemplateCells = true;

    public XmlAreaBuilder(Transformer transformer) {
        this.transformer = transformer;
    }

    public XmlAreaBuilder(InputStream xmlInputStream, Transformer transformer) {
        this.xmlInputStream = xmlInputStream;
        this.transformer = transformer;
    }

    public XmlAreaBuilder(InputStream xmlInputStream, Transformer transformer, boolean clearTemplateCells) {
        this.xmlInputStream = xmlInputStream;
        this.transformer = transformer;
        this.clearTemplateCells = clearTemplateCells;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public List<Area> build(InputStream is) {
        HashMap<ElementSelector, Action> ruleMap = new HashMap<ElementSelector, Action>();
        AreaAction areaAction = new AreaAction(this.transformer);
        ruleMap.put(new ElementSelector("*/area"), areaAction);
        ruleMap.put(new ElementSelector("*/each"), new EachAction());
        ruleMap.put(new ElementSelector("*/if"), new IfAction());
        ruleMap.put(new ElementSelector("*/user-command"), new UserCommandAction());
        ruleMap.put(new ElementSelector("*/grid"), new GridAction());
        ruleMap.put(new ElementSelector("*/user-action"), (Action)new NewRuleAction());
        ContextBase context = new ContextBase();
        SimpleConfigurator simpleConfigurator = new SimpleConfigurator(ruleMap);
        simpleConfigurator.setContext((Context)context);
        try {
            simpleConfigurator.doConfigure(is);
        }
        catch (JoranException e) {
            this.printOccurredErrors((Context)context);
        }
        if (this.clearTemplateCells) {
            for (Area area : areaAction.getAreaList()) {
                ((XlsArea)area).clearCells();
            }
        }
        return areaAction.getAreaList();
    }

    @Override
    public List<Area> build() {
        return this.build(this.xmlInputStream);
    }

    private void printOccurredErrors(Context context) {
        StatusPrinter.print((Context)context);
    }
}

