/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.protocol.WialonProtocolDecoder;
import org.traccar.protocol.WialonProtocolEncoder;

public class WialonProtocol
extends BaseProtocol {
    @Inject
    public WialonProtocol(Config config) {
        this.setSupportedDataCommands("rebootDevice", "sendUssd", "deviceIdentification", "outputControl");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new LineBasedFrameDecoder(4096));
                boolean utf8 = config.getBoolean(Keys.PROTOCOL_UTF8.withPrefix(WialonProtocol.this.getName()));
                if (utf8) {
                    pipeline.addLast((ChannelHandler)new StringEncoder(StandardCharsets.UTF_8));
                    pipeline.addLast((ChannelHandler)new StringDecoder(StandardCharsets.UTF_8));
                } else {
                    pipeline.addLast((ChannelHandler)new StringEncoder());
                    pipeline.addLast((ChannelHandler)new StringDecoder());
                }
                pipeline.addLast((ChannelHandler)new WialonProtocolEncoder(WialonProtocol.this));
                pipeline.addLast((ChannelHandler)new WialonProtocolDecoder(WialonProtocol.this));
            }
        });
        this.addServer(new TrackerServer(config, this.getName(), true){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new LineBasedFrameDecoder(4096));
                boolean utf8 = config.getBoolean(Keys.PROTOCOL_UTF8.withPrefix(WialonProtocol.this.getName()));
                if (utf8) {
                    pipeline.addLast((ChannelHandler)new StringEncoder(StandardCharsets.UTF_8));
                    pipeline.addLast((ChannelHandler)new StringDecoder(StandardCharsets.UTF_8));
                } else {
                    pipeline.addLast((ChannelHandler)new StringEncoder());
                    pipeline.addLast((ChannelHandler)new StringDecoder());
                }
                pipeline.addLast((ChannelHandler)new WialonProtocolEncoder(WialonProtocol.this));
                pipeline.addLast((ChannelHandler)new WialonProtocolDecoder(WialonProtocol.this));
            }
        });
    }
}

