/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.geocoder.Geocoder;
import org.traccar.helper.Log;
import org.traccar.helper.LogAction;
import org.traccar.mail.MailManager;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="server")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServerResource
extends BaseResource {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private MailManager mailManager;
    @Inject
    @Nullable
    private Geocoder geocoder;

    @PermitAll
    @GET
    public Server get() throws StorageException {
        Server server = this.storage.getObject(Server.class, new Request(new Columns.All()));
        server.setEmailEnabled(this.mailManager.getEmailEnabled());
        server.setGeocoderEnabled(this.geocoder != null);
        User user = this.permissionsService.getUser(this.getUserId());
        if (user != null && user.getAdministrator()) {
            server.setStorageSpace(Log.getStorageSpace());
        }
        return server;
    }

    @PUT
    public Response update(Server entity) throws StorageException {
        this.permissionsService.checkAdmin(this.getUserId());
        this.storage.updateObject(entity, new Request(new Columns.Exclude("id"), new Condition.Equals("id", "id")));
        this.cacheManager.updateOrInvalidate(true, entity);
        LogAction.edit(this.getUserId(), entity);
        return Response.ok((Object)entity).build();
    }

    @Path(value="geocode")
    @GET
    public String geocode(@QueryParam(value="latitude") double latitude, @QueryParam(value="longitude") double longitude) {
        if (this.geocoder != null) {
            return this.geocoder.getAddress(latitude, longitude, null);
        }
        throw new RuntimeException("Reverse geocoding is not enabled");
    }

    @Path(value="timezones")
    @GET
    public Collection<String> timezones() {
        return Arrays.asList(TimeZone.getAvailableIDs());
    }
}

