/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.misc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.exception.IllegalJsonArgumentException;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Lists;
import net.thisptr.jackson.jq.internal.misc.Range;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedAllFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedEmptyFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedIndexFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedRangeFieldAccess;
import net.thisptr.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedStringFieldAccess;

public class JsonNodeUtils {
    private JsonNodeUtils() {
    }

    public static boolean asBoolean(JsonNode n) {
        if (n == null || n.isNull() || n.isMissingNode()) {
            return false;
        }
        if (n.isBoolean()) {
            return n.asBoolean();
        }
        return true;
    }

    public static boolean isIntegralNumber(JsonNode n) {
        if (!n.isNumber()) {
            return false;
        }
        return n.asDouble() == (double)n.asLong();
    }

    public static JsonNode asNumericNode(long value) {
        if ((long)((int)value) == value) {
            return new IntNode((int)value);
        }
        return new LongNode(value);
    }

    public static JsonNode asNumericNode(double value) {
        if ((double)((int)value) == value) {
            return new IntNode((int)value);
        }
        if ((double)((long)value) == value) {
            return new LongNode((long)value);
        }
        return new DoubleNode(value);
    }

    public static ArrayNode asArrayNode(ObjectMapper mapper, List<JsonNode> values) {
        ArrayNode result = mapper.createArrayNode();
        result.addAll(values);
        return result;
    }

    public static List<JsonNode> asArrayList(ArrayNode in) {
        return Lists.newArrayList(in);
    }

    public static String typeOf(JsonNode in) {
        if (in == null) {
            return "null";
        }
        switch (in.getNodeType()) {
            case ARRAY: {
                return "array";
            }
            case BINARY: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case MISSING: {
                return "null";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                return "number";
            }
            case OBJECT: {
                return "object";
            }
            case STRING: {
                return "string";
            }
        }
        throw new IllegalArgumentException("Unknown JsonNodeType: " + in.getNodeType());
    }

    public static void copy(ArrayNode out, JsonNode in) throws JsonQueryException {
        if (!in.isArray()) {
            throw new IllegalJsonArgumentException("input must be ARRAY");
        }
        for (JsonNode i : in) {
            out.add(i);
        }
    }

    public static void copy(ObjectNode out, JsonNode in) throws JsonQueryException {
        if (!in.isObject()) {
            throw new IllegalJsonArgumentException("input must be OBJECT");
        }
        Iterator iter = in.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            out.set((String)entry.getKey(), (JsonNode)entry.getValue());
        }
    }

    public static JsonNode mutate(ObjectMapper mapper, JsonNode in, List<ResolvedFieldAccess> path, Mutation mutation, boolean creative) throws JsonQueryException {
        if (path.isEmpty()) {
            return mutation.apply(in);
        }
        ResolvedFieldAccess accessHead = path.get(0);
        List<ResolvedFieldAccess> accessTail = path.subList(1, path.size());
        if (accessHead instanceof ResolvedEmptyFieldAccess) {
            return in;
        }
        if (accessHead instanceof ResolvedIndexFieldAccess) {
            ResolvedIndexFieldAccess access = (ResolvedIndexFieldAccess)accessHead;
            if (in.isNull()) {
                if (!creative) {
                    return NullNode.getInstance();
                }
                ArrayNode result = mapper.createArrayNode();
                for (long index : access.indices()) {
                    if (index < 0L) {
                        throw new JsonQueryException("Out of bounds negative array index");
                    }
                    while (index >= (long)result.size()) {
                        result.add((JsonNode)NullNode.getInstance());
                    }
                    result.set((int)index, JsonNodeUtils.mutate(mapper, (JsonNode)NullNode.getInstance(), accessTail, mutation, creative));
                }
                return result;
            }
            if (in.isArray()) {
                ArrayNode result = mapper.createArrayNode();
                ArrayNode tmp = mapper.createArrayNode();
                JsonNodeUtils.copy(tmp, in);
                Iterator index = access.indices().iterator();
                while (index.hasNext()) {
                    JsonNode newvalue;
                    long index2 = index.next();
                    index2 = index2 >= 0L ? index2 : index2 + (long)in.size();
                    JsonNode value = tmp.get((int)index2);
                    if (value == null && creative) {
                        value = NullNode.getInstance();
                    }
                    if ((newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative)) != null) {
                        while (index2 >= (long)tmp.size()) {
                            tmp.add((JsonNode)NullNode.getInstance());
                        }
                        tmp.set((int)index2, newvalue);
                        continue;
                    }
                    tmp.set((int)index2, (JsonNode)MissingNode.getInstance());
                }
                for (JsonNode t : tmp) {
                    if (t.isMissingNode()) continue;
                    result.add(t);
                }
                return result;
            }
            if (!accessHead.permissive) {
                throw JsonQueryException.format("Cannot index %s with number", in.getNodeType());
            }
            return in;
        }
        if (accessHead instanceof ResolvedStringFieldAccess) {
            ResolvedStringFieldAccess access = (ResolvedStringFieldAccess)accessHead;
            if (in.isNull()) {
                if (!creative) {
                    return NullNode.getInstance();
                }
                ObjectNode result = mapper.createObjectNode();
                for (String key : access.keys()) {
                    result.set(key, JsonNodeUtils.mutate(mapper, (JsonNode)NullNode.getInstance(), accessTail, mutation, creative));
                }
                return result;
            }
            if (in.isObject()) {
                ObjectNode result = mapper.createObjectNode();
                JsonNodeUtils.copy(result, in);
                for (String key : access.keys()) {
                    JsonNode newvalue;
                    JsonNode value = result.get(key);
                    if (value == null && creative) {
                        value = NullNode.getInstance();
                    }
                    if ((newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative)) == null) {
                        result.remove(key);
                        continue;
                    }
                    if (newvalue == value) continue;
                    result.set(key, newvalue);
                }
                return result;
            }
            if (!accessHead.permissive) {
                throw JsonQueryException.format("Cannot index %s with string \"%s\"", in.getNodeType(), access.keys().get(0));
            }
            return in;
        }
        if (accessHead instanceof ResolvedRangeFieldAccess) {
            ResolvedRangeFieldAccess access = (ResolvedRangeFieldAccess)accessHead;
            if (in.isNull()) {
                JsonNode newvalue = JsonNodeUtils.mutate(mapper, (JsonNode)NullNode.getInstance(), accessTail, mutation, creative);
                if (!newvalue.isArray()) {
                    throw new JsonQueryException("A slice of an array can only be assigned another array");
                }
                return newvalue;
            }
            if (in.isArray()) {
                ArrayNode result = mapper.createArrayNode();
                JsonNodeUtils.copy(result, in);
                ArrayNode tmp = mapper.createArrayNode();
                for (Range range : access.ranges()) {
                    range = range.over(result.size());
                    int i = 0;
                    while ((long)i < range.begin) {
                        tmp.add(result.get(i));
                        ++i;
                    }
                    ArrayNode slice = mapper.createArrayNode();
                    int i2 = (int)range.begin;
                    while ((long)i2 < range.end) {
                        slice.add(result.get(i2));
                        ++i2;
                    }
                    JsonNode newvalue = JsonNodeUtils.mutate(mapper, (JsonNode)slice, accessTail, mutation, creative);
                    if (newvalue != null && newvalue.isArray()) {
                        for (JsonNode t : newvalue) {
                            tmp.add(t);
                        }
                    } else if (newvalue != null) {
                        throw new JsonQueryException("A slice of an array can only be assigned another array");
                    }
                    for (int i3 = (int)range.end; i3 < result.size(); ++i3) {
                        tmp.add(result.get(i3));
                    }
                    result = tmp;
                }
                return result;
            }
            if (in.isTextual()) {
                throw new JsonQueryException("Cannot update field at object index of string");
            }
            if (!accessHead.permissive) {
                throw JsonQueryException.format("Cannot index %s with object", in.getNodeType());
            }
            return in;
        }
        if (accessHead instanceof ResolvedAllFieldAccess) {
            if (in.isNull()) {
                throw new JsonQueryException("Cannot iterate over null");
            }
            if (in.isObject()) {
                ObjectNode result = mapper.createObjectNode();
                Iterator iter = in.fields();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    String key = (String)entry.getKey();
                    JsonNode value = (JsonNode)entry.getValue();
                    JsonNode newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative);
                    if (newvalue == null) continue;
                    result.set(key, newvalue);
                }
                return result;
            }
            if (in.isArray()) {
                ArrayNode result = mapper.createArrayNode();
                for (int key = 0; key < in.size(); ++key) {
                    JsonNode value = in.get(key);
                    JsonNode newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative);
                    if (newvalue == null) continue;
                    result.add(newvalue);
                }
                return result;
            }
            throw JsonQueryException.format("Cannot iterate over %s", in.getNodeType());
        }
        throw new IllegalStateException();
    }

    public static interface Mutation {
        public JsonNode apply(JsonNode var1) throws JsonQueryException;
    }
}

