/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analytics.AnalyticsExpression;
import org.apache.solr.analytics.AnalyticsGroupingManager;
import org.apache.solr.analytics.facet.AbstractSolrQueryFacet;
import org.apache.solr.analytics.facet.StreamingFacet;
import org.apache.solr.analytics.function.ExpressionCalculator;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.analytics.stream.AnalyticsShardRequestManager;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.Filter;

public class AnalyticsRequestManager {
    private final ReductionCollectionManager ungroupedReductionManager;
    private ReductionCollectionManager.ReductionDataCollection ungroupedData;
    private final Map<String, AnalyticsGroupingManager> groupingManagers;
    private final Collection<AnalyticsExpression> ungroupedExpressions;
    private final ExpressionCalculator ungroupedExpressionCalculator;
    public String analyticsRequest;
    public AnalyticsShardRequestManager shardStream;
    public boolean sendShards;
    private boolean partialResults = false;

    public AnalyticsRequestManager(ReductionCollectionManager ungroupedReductionManager, Collection<AnalyticsExpression> ungroupedExpressions) {
        this.ungroupedReductionManager = ungroupedReductionManager;
        this.ungroupedData = ungroupedReductionManager.newDataCollection();
        this.ungroupedReductionManager.addLastingCollectTarget(this.ungroupedData);
        this.ungroupedExpressions = ungroupedExpressions;
        this.ungroupedExpressionCalculator = new ExpressionCalculator(ungroupedExpressions);
        this.groupingManagers = new HashMap<String, AnalyticsGroupingManager>();
    }

    public ReductionCollectionManager getUngroupedCollectionManager() {
        return this.ungroupedReductionManager;
    }

    public ReductionCollectionManager.ReductionDataCollection getUngroupedData() {
        return this.ungroupedData;
    }

    public Iterable<AnalyticsExpression> getUngroupedExpressions() {
        return this.ungroupedExpressions;
    }

    public void addUngroupedResults(Map<String, Object> response) {
        this.ungroupedReductionManager.setData(this.ungroupedData);
        this.ungroupedExpressionCalculator.addResults(response);
    }

    public Map<String, Object> getUngroupedResults() {
        this.ungroupedReductionManager.setData(this.ungroupedData);
        return this.ungroupedExpressionCalculator.getResults();
    }

    public void addGrouping(AnalyticsGroupingManager groupingManager) {
        this.groupingManagers.put(groupingManager.getName(), groupingManager);
    }

    public synchronized void importShardData(DataInput input) throws IOException {
        this.ungroupedReductionManager.setShardInput(input);
        if (this.ungroupedData == null) {
            this.ungroupedData = this.ungroupedReductionManager.newDataCollectionIO();
        } else {
            this.ungroupedReductionManager.prepareReductionDataIO(this.ungroupedData);
        }
        this.ungroupedReductionManager.mergeData();
        int size = input.readInt();
        while (--size >= 0) {
            String groupingName = input.readUTF();
            this.groupingManagers.get(groupingName).importShardData(input);
        }
    }

    public void exportShardData(DataOutput output) throws IOException {
        this.ungroupedReductionManager.setShardOutput(output);
        this.ungroupedReductionManager.prepareReductionDataIO(this.ungroupedData);
        this.ungroupedReductionManager.exportData();
        output.writeInt(this.groupingManagers.size());
        for (Map.Entry<String, AnalyticsGroupingManager> entry : this.groupingManagers.entrySet()) {
            output.writeUTF(entry.getKey());
            entry.getValue().exportShardData(output);
        }
    }

    public StreamingInfo getStreamingFacetInfo() {
        StreamingInfo streamingInfo = new StreamingInfo();
        ArrayList<ReductionCollectionManager> groupingCollectors = new ArrayList<ReductionCollectionManager>();
        this.groupingManagers.values().forEach(grouping -> {
            if (grouping.getStreamingFacets(facet -> streamingInfo.streamingFacets.add((StreamingFacet)facet))) {
                groupingCollectors.add(grouping.getReductionManager());
            }
        });
        streamingInfo.streamingCollectionManager = this.ungroupedReductionManager.merge(groupingCollectors);
        return streamingInfo;
    }

    public Iterable<AbstractSolrQueryFacet.FacetValueQueryExecuter> getFacetExecuters(Filter filter, SolrQueryRequest queryRequest) {
        ArrayList<AbstractSolrQueryFacet.FacetValueQueryExecuter> facetExecutors = new ArrayList<AbstractSolrQueryFacet.FacetValueQueryExecuter>();
        this.groupingManagers.values().forEach(grouping -> grouping.getFacetExecuters(filter, queryRequest, executor -> facetExecutors.add((AbstractSolrQueryFacet.FacetValueQueryExecuter)((Object)executor))));
        return facetExecutors;
    }

    public NamedList<Object> createOldResponse() {
        NamedList analyticsResponse = new NamedList();
        Map<String, Object> ungroupedResults = this.getUngroupedResults();
        this.groupingManagers.forEach((name, groupingManager) -> analyticsResponse.add(name, groupingManager.createOldResponse(ungroupedResults)));
        return analyticsResponse;
    }

    public Map<String, Object> createResponse() {
        HashMap<String, Object> analyticsResponse = new HashMap<String, Object>();
        if (this.ungroupedExpressions.size() > 0) {
            this.addUngroupedResults(analyticsResponse);
        }
        HashMap groupingsResponse = new HashMap();
        this.groupingManagers.forEach((name, groupingManager) -> groupingsResponse.put(name, groupingManager.createResponse()));
        if (groupingsResponse.size() > 0) {
            analyticsResponse.put("groupings", groupingsResponse);
        }
        return analyticsResponse;
    }

    public void setPartialResults(boolean b) {
        this.partialResults = b;
    }

    public boolean isPartialResults() {
        return this.partialResults;
    }

    public static class StreamingInfo {
        Collection<StreamingFacet> streamingFacets = new ArrayList<StreamingFacet>();
        ReductionCollectionManager streamingCollectionManager;
    }
}

