/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml.actions;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMLSearchSession;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMlSearchState;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereMlSessionService;
import com.intellij.ide.actions.searcheverywhere.ml.SearchEverywhereTabWithMl;
import com.intellij.ide.actions.searcheverywhere.ml.id.SearchEverywhereMlItemIdProvider;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createNewJsonScratchFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/ide/scratch/ScratchFileCreationHelper$Context;", "createScratchFileContext", "json", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getFeaturesReport", "", "", "searchEverywhereUI", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereUI;", "isTabWithMl", "", "tabId", "openScratchFile", "file", "shouldActionBeEnabled", "update", "Companion", "ContributorInfo", "ElementFeatures", "intellij.searchEverywhereMl"})
public final class OpenFeaturesInScratchFileAction
extends AnAction {
    private static final String SHOULD_ORDER_BY_ML_KEY = "shouldOrderByMl";
    private static final String CONTEXT_INFO_KEY = "contextInfo";
    private static final String SEARCH_STATE_FEATURES_KEY = "searchStateFeatures";
    private static final String CONTRIBUTORS_KEY = "contributors";
    private static final String FOUND_ELEMENTS_KEY = "foundElements";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(this.shouldActionBeEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldActionBeEnabled(AnActionEvent e) {
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance((Project)e.getProject());
        SearchEverywhereMLSearchSession session = SearchEverywhereMlSessionService.Companion.getService().getCurrentSession();
        if (e.getProject() == null) return false;
        SearchEverywhereManager searchEverywhereManager = seManager;
        Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereManager, (String)"seManager");
        if (!searchEverywhereManager.isShown()) return false;
        if (session == null) return false;
        if (session.getCurrentSearchState() == null) return false;
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String json;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SearchEverywhereManager searchEverywhereManager = SearchEverywhereManager.getInstance((Project)e.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereManager, (String)"SearchEverywhereManager.getInstance(e.project)");
        SearchEverywhereUI searchEverywhereUI = searchEverywhereManager.getCurrentlyShownUI();
        Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereUI, (String)"SearchEverywhereManager.\u2026project).currentlyShownUI");
        SearchEverywhereUI searchEverywhereUI2 = searchEverywhereUI;
        Map<String, Object> report = this.getFeaturesReport(searchEverywhereUI2);
        String string = json = ExtensionsKt.jacksonObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(report);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json");
        ScratchFileCreationHelper.Context context = this.createScratchFileContext(string);
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project!!");
        VirtualFile scratchFile = this.createNewJsonScratchFile(project2, context);
        Project project3 = e.getProject();
        Intrinsics.checkNotNull((Object)project3);
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"e.project!!");
        this.openScratchFile(scratchFile, project3);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getFeaturesReport(SearchEverywhereUI searchEverywhereUI) {
        void $this$mapTo$iv$iv;
        EventPair it;
        Iterable $this$associateTo$iv$iv;
        Iterable $this$associate$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Pair[] pairArray;
        void $this$mapTo$iv$iv3;
        SearchEverywhereMlSessionService mlSessionService = SearchEverywhereMlSessionService.Companion.getService();
        SearchEverywhereMLSearchSession searchEverywhereMLSearchSession = mlSessionService.getCurrentSession();
        Intrinsics.checkNotNull((Object)searchEverywhereMLSearchSession);
        SearchEverywhereMLSearchSession searchSession = searchEverywhereMLSearchSession;
        SearchEverywhereMlSearchState state = searchSession.getCurrentSearchState();
        String tabId = searchEverywhereUI.getSelectedTabID();
        List list = searchEverywhereUI.getFoundElementsInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"searchEverywhereUI.foundElementsInfo");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = (Pair[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            String contributor;
            String elementName;
            Double d;
            void info;
            SearchEverywhereFoundElementInfo searchEverywhereFoundElementInfo = (SearchEverywhereFoundElementInfo)item$iv$iv;
            pairArray = destination$iv$iv;
            boolean bl = false;
            int rankingWeight = info.priority;
            SearchEverywhereContributor searchEverywhereContributor = info.contributor;
            Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor, (String)"info.contributor");
            Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor.getSearchProviderId(), (String)"info.contributor.searchProviderId");
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.notNullize((String)info.element.toString(), (String)"undefined"), (String)"StringUtil.notNullize(in\u2026.toString(), \"undefined\")");
            String string = tabId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tabId");
            if (this.isTabWithMl(string)) {
                SearchEverywhereContributor searchEverywhereContributor2 = info.contributor;
                Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor2, (String)"info.contributor");
                Object object2 = info.element;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"info.element");
                d = mlSessionService.getMlWeight(searchEverywhereContributor2, object2, rankingWeight);
            } else {
                d = null;
            }
            Double mlWeight = d;
            SearchEverywhereMlItemIdProvider searchEverywhereMlItemIdProvider = searchSession.getItemIdProvider();
            Object object3 = info.element;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"info.element");
            Integer elementId = searchEverywhereMlItemIdProvider.getId(object3);
            SearchEverywhereMlSearchState searchEverywhereMlSearchState = state;
            Intrinsics.checkNotNull((Object)searchEverywhereMlSearchState);
            Object object4 = info.element;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"info.element");
            SearchEverywhereContributor searchEverywhereContributor3 = info.contributor;
            Intrinsics.checkNotNullExpressionValue((Object)searchEverywhereContributor3, (String)"info.contributor");
            object = new ElementFeatures(elementId, elementName, mlWeight, rankingWeight, contributor, MapsKt.toSortedMap(searchEverywhereMlSearchState.getElementFeatures(elementId, object4, searchEverywhereContributor3, rankingWeight).featuresAsMap()));
            pairArray.add(object);
        }
        List features2 = (List)destination$iv$iv;
        List list2 = searchEverywhereUI.getFoundElementsInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"searchEverywhereUI.foundElementsInfo");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void info;
            SearchEverywhereFoundElementInfo bl = (SearchEverywhereFoundElementInfo)item$iv$iv;
            pairArray = destination$iv$iv2;
            boolean bl2 = false;
            object = info.contributor;
            pairArray.add(object);
        }
        HashSet contributors = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        Pair[] pairArray2 = new Pair[5];
        pairArray2[0] = TuplesKt.to((Object)SHOULD_ORDER_BY_ML_KEY, (Object)mlSessionService.shouldOrderByMl());
        $this$map$iv2 = searchSession.getCachedContextInfo().getFeatures();
        String string = CONTEXT_INFO_KEY;
        int n = 1;
        object = pairArray2;
        pairArray = pairArray2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl2 = destination$iv$iv3;
            it = (EventPair)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getField().getName(), (Object)it.getData());
            bl2.put(it.getFirst(), it.getSecond());
        }
        Object object5 = destination$iv$iv3;
        object[n] = TuplesKt.to((Object)string, (Object)object5);
        SearchEverywhereMlSearchState searchEverywhereMlSearchState = state;
        Intrinsics.checkNotNull((Object)searchEverywhereMlSearchState);
        $this$associate$iv = searchEverywhereMlSearchState.getSearchStateFeatures();
        string = SEARCH_STATE_FEATURES_KEY;
        n = 2;
        object = pairArray;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl2 = destination$iv$iv3;
            it = (EventPair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getField().getName(), (Object)it.getData());
            bl2.put(pair.getFirst(), pair.getSecond());
        }
        object5 = destination$iv$iv3;
        object[n] = TuplesKt.to((Object)string, (Object)object5);
        $this$associate$iv = contributors;
        string = CONTRIBUTORS_KEY;
        n = 3;
        object = pairArray;
        $i$f$map2 = false;
        Iterable capacity$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void c;
            SearchEverywhereContributor element$iv$iv = (SearchEverywhereContributor)item$iv$iv;
            object5 = destination$iv$iv2;
            boolean bl = false;
            void v15 = c;
            Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"c");
            String string2 = v15.getSearchProviderId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"c.searchProviderId");
            ContributorInfo contributorInfo = new ContributorInfo(string2, c.getSortWeight());
            object5.add(contributorInfo);
        }
        object5 = (List)destination$iv$iv2;
        object[n] = TuplesKt.to((Object)string, (Object)object5);
        pairArray[4] = TuplesKt.to((Object)FOUND_ELEMENTS_KEY, (Object)features2);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean isTabWithMl(String tabId) {
        return SearchEverywhereTabWithMl.Companion.findById(tabId) != null;
    }

    private final ScratchFileCreationHelper.Context createScratchFileContext(String json) {
        ScratchFileCreationHelper.Context context;
        ScratchFileCreationHelper.Context $this$apply = context = new ScratchFileCreationHelper.Context();
        boolean bl = false;
        $this$apply.text = json;
        $this$apply.fileExtension = "json";
        $this$apply.createOption = ScratchFileService.Option.create_if_missing;
        return context;
    }

    private final VirtualFile createNewJsonScratchFile(Project project2, ScratchFileCreationHelper.Context context) {
        String fileName = "search-everywhere-features." + context.fileExtension;
        VirtualFile virtualFile = ScratchRootType.getInstance().createScratchFile(project2, fileName, context.language, context.text, context.createOption);
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    private final void openScratchFile(VirtualFile file, Project project2) {
        FileEditorManager.getInstance((Project)project2).openFile(file, true);
    }

    @JsonPropertyOrder(value={"id", "name", "mlWeight", "rankingWeight", "contributor", "features"})
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0083\b\u0018\u00002\u00020\u0001BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000bH\u00c6\u0003JZ\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$ElementFeatures;", "", "id", "", "name", "", "mlWeight", "", "rankingWeight", "contributor", "features", "", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Double;ILjava/lang/String;Ljava/util/Map;)V", "getContributor", "()Ljava/lang/String;", "getFeatures", "()Ljava/util/Map;", "getId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMlWeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getName", "getRankingWeight", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Double;ILjava/lang/String;Ljava/util/Map;)Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$ElementFeatures;", "equals", "", "other", "hashCode", "toString", "intellij.searchEverywhereMl"})
    private static final class ElementFeatures {
        @Nullable
        private final Integer id;
        @NotNull
        private final String name;
        @Nullable
        private final Double mlWeight;
        private final int rankingWeight;
        @NotNull
        private final String contributor;
        @NotNull
        private final Map<String, Object> features;

        @Nullable
        public final Integer getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Double getMlWeight() {
            return this.mlWeight;
        }

        public final int getRankingWeight() {
            return this.rankingWeight;
        }

        @NotNull
        public final String getContributor() {
            return this.contributor;
        }

        @NotNull
        public final Map<String, Object> getFeatures() {
            return this.features;
        }

        public ElementFeatures(@Nullable Integer id, @NotNull String name, @Nullable Double mlWeight, int rankingWeight, @NotNull String contributor, @NotNull Map<String, ? extends Object> features2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            this.id = id;
            this.name = name;
            this.mlWeight = mlWeight;
            this.rankingWeight = rankingWeight;
            this.contributor = contributor;
            this.features = features2;
        }

        @Nullable
        public final Integer component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @Nullable
        public final Double component3() {
            return this.mlWeight;
        }

        public final int component4() {
            return this.rankingWeight;
        }

        @NotNull
        public final String component5() {
            return this.contributor;
        }

        @NotNull
        public final Map<String, Object> component6() {
            return this.features;
        }

        @NotNull
        public final ElementFeatures copy(@Nullable Integer id, @NotNull String name, @Nullable Double mlWeight, int rankingWeight, @NotNull String contributor, @NotNull Map<String, ? extends Object> features2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            return new ElementFeatures(id, name, mlWeight, rankingWeight, contributor, features2);
        }

        public static /* synthetic */ ElementFeatures copy$default(ElementFeatures elementFeatures, Integer n, String string, Double d, int n2, String string2, Map map, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = elementFeatures.id;
            }
            if ((n3 & 2) != 0) {
                string = elementFeatures.name;
            }
            if ((n3 & 4) != 0) {
                d = elementFeatures.mlWeight;
            }
            if ((n3 & 8) != 0) {
                n2 = elementFeatures.rankingWeight;
            }
            if ((n3 & 0x10) != 0) {
                string2 = elementFeatures.contributor;
            }
            if ((n3 & 0x20) != 0) {
                map = elementFeatures.features;
            }
            return elementFeatures.copy(n, string, d, n2, string2, map);
        }

        @NotNull
        public String toString() {
            return "ElementFeatures(id=" + this.id + ", name=" + this.name + ", mlWeight=" + this.mlWeight + ", rankingWeight=" + this.rankingWeight + ", contributor=" + this.contributor + ", features=" + this.features + ")";
        }

        public int hashCode() {
            Integer n = this.id;
            String string = this.name;
            Double d = this.mlWeight;
            String string2 = this.contributor;
            Map<String, Object> map = this.features;
            return (((((n != null ? ((Object)n).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (d != null ? ((Object)d).hashCode() : 0)) * 31 + Integer.hashCode(this.rankingWeight)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ElementFeatures)) break block3;
                    ElementFeatures elementFeatures = (ElementFeatures)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)elementFeatures.id) || !Intrinsics.areEqual((Object)this.name, (Object)elementFeatures.name) || !Intrinsics.areEqual((Object)this.mlWeight, (Object)elementFeatures.mlWeight) || this.rankingWeight != elementFeatures.rankingWeight || !Intrinsics.areEqual((Object)this.contributor, (Object)elementFeatures.contributor) || !Intrinsics.areEqual(this.features, elementFeatures.features)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @JsonPropertyOrder(value={"id", "weight"})
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0083\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$ContributorInfo;", "", "id", "", "weight", "", "(Ljava/lang/String;I)V", "getId", "()Ljava/lang/String;", "getWeight", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.searchEverywhereMl"})
    private static final class ContributorInfo {
        @NotNull
        private final String id;
        private final int weight;

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final int getWeight() {
            return this.weight;
        }

        public ContributorInfo(@NotNull String id, int weight) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.weight = weight;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        public final int component2() {
            return this.weight;
        }

        @NotNull
        public final ContributorInfo copy(@NotNull String id, int weight) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new ContributorInfo(id, weight);
        }

        public static /* synthetic */ ContributorInfo copy$default(ContributorInfo contributorInfo, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = contributorInfo.id;
            }
            if ((n2 & 2) != 0) {
                n = contributorInfo.weight;
            }
            return contributorInfo.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ContributorInfo(id=" + this.id + ", weight=" + this.weight + ")";
        }

        public int hashCode() {
            String string = this.id;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.weight);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ContributorInfo)) break block3;
                    ContributorInfo contributorInfo = (ContributorInfo)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)contributorInfo.id) || this.weight != contributorInfo.weight) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/searcheverywhere/ml/actions/OpenFeaturesInScratchFileAction$Companion;", "", "()V", "CONTEXT_INFO_KEY", "", "CONTRIBUTORS_KEY", "FOUND_ELEMENTS_KEY", "SEARCH_STATE_FEATURES_KEY", "SHOULD_ORDER_BY_ML_KEY", "intellij.searchEverywhereMl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

