/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.IdeaWatchdog;
import com.intellij.execution.rmi.IdeaWatchdogImpl;
import com.intellij.execution.rmi.ssl.SslKeyStore;
import com.intellij.execution.rmi.ssl.SslSocketFactory;
import com.intellij.execution.rmi.ssl.SslTrustStore;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.Hashtable;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServer {
    public static final String SERVER_HOSTNAME = "java.rmi.server.hostname";
    private static final Pattern REF_ENDPOINT_PATTERN = Pattern.compile("endpoint:\\[.*:(\\d+)]");
    private static Remote ourRemote;

    protected static void start(Remote remote) throws Exception {
        RemoteServer.start(remote, true);
    }

    protected static void start(Remote remote, boolean localHostOnly) throws Exception {
        Registry registry;
        int port;
        RemoteServer.setupRMI(localHostOnly);
        RemoteServer.banJNDI();
        RemoteServer.setupSSL();
        if (ourRemote != null) {
            throw new AssertionError((Object)"Already started");
        }
        ourRemote = remote;
        Random random = new Random();
        while (true) {
            if ((port = random.nextInt(65535)) < 4000) {
                continue;
            }
            try {
                if (localHostOnly) {
                    registry = LocateRegistry.createRegistry(port);
                    break;
                }
                registry = LocateRegistry.createRegistry(port, null, RMISocketFactory.getSocketFactory());
            }
            catch (ExportException exportException) {
                continue;
            }
            break;
        }
        try {
            Remote stub = UnicastRemoteObject.exportObject(ourRemote, 0);
            String name = remote.getClass().getSimpleName() + Integer.toHexString(stub.hashCode());
            registry.bind(name, stub);
            Matcher matcher = REF_ENDPOINT_PATTERN.matcher(stub.toString());
            String servicesPort = matcher.find() ? matcher.group(1) : "0";
            IdeaWatchdogImpl watchdog = new IdeaWatchdogImpl();
            Remote watchdogStub = UnicastRemoteObject.exportObject((Remote)watchdog, 0);
            registry.bind("_LIVE_PULSE_", watchdogStub);
            System.out.println("Port/ServicesPort/ID: " + port + "/" + servicesPort + "/" + name);
            System.out.println();
            RemoteServer.spinUntilWatchdogAlive(watchdog);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void spinUntilWatchdogAlive(IdeaWatchdog watchdog) throws Exception {
        long waitTime = 20000L;
        Object lock = new Object();
        while (true) {
            Object object = lock;
            synchronized (object) {
                lock.wait(waitTime);
            }
            if (watchdog.isAlive()) continue;
            System.exit(1);
        }
    }

    public static void setupRMI(final boolean localHostOnly) {
        if (System.getProperty(SERVER_HOSTNAME) == null) {
            System.setProperty(SERVER_HOSTNAME, RemoteServer.getLoopbackAddress());
        }
        System.setProperty("java.rmi.server.disableHttp", "true");
        if (RMISocketFactory.getSocketFactory() != null) {
            return;
        }
        try {
            RMISocketFactory.setSocketFactory(new RMISocketFactory(){
                final InetAddress loopbackAddress;
                {
                    this.loopbackAddress = InetAddress.getByName(RemoteServer.getListenAddress(localHostOnly));
                }

                @Override
                public Socket createSocket(String host, int port) throws IOException {
                    Socket socket = new Socket(host, port);
                    socket.setKeepAlive(true);
                    return socket;
                }

                @Override
                public ServerSocket createServerSocket(int port) throws IOException {
                    return new ServerSocket(port, 0, this.loopbackAddress);
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void banJNDI() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", "com.intellij.execution.rmi.RemoteServer$Jndi");
        }
    }

    private static void setupSSL() {
        RemoteServer.setupDisabledAlgorithms();
        boolean caCert = System.getProperty("sslCaCertPath") != null;
        boolean clientCert = System.getProperty("sslClientCertPath") != null;
        boolean clientKey = System.getProperty("sslClientKeyPath") != null;
        boolean deferred = "true".equals(System.getProperty("sslDeferredKeyLoading"));
        boolean useFactory = "true".equals(System.getProperty("sslUseFactory"));
        if (useFactory) {
            if (caCert || clientCert && clientKey) {
                Security.setProperty("ssl.SocketFactory.provider", SslSocketFactory.class.getName());
            }
        } else {
            if (caCert) {
                SslTrustStore.setDefault();
            }
            if (clientCert && clientKey || deferred) {
                SslKeyStore.setDefault();
            }
        }
    }

    private static void setupDisabledAlgorithms() {
        RemoteServer.passSecurityProperty("jdk.certpath.disabledAlgorithms");
        RemoteServer.passSecurityProperty("jdk.tls.disabledAlgorithms");
    }

    private static void passSecurityProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            Security.setProperty(propertyName, value);
        }
    }

    private static String getListenAddress(boolean localHostOnly) {
        if (localHostOnly) {
            return RemoteServer.getLoopbackAddress();
        }
        return RemoteServer.isIpV6() ? "::/0" : "0.0.0.0";
    }

    @NotNull
    private static String getLoopbackAddress() {
        return RemoteServer.isIpV6() ? "::1" : "127.0.0.1";
    }

    private static boolean isIpV6() {
        try {
            return InetAddress.getByName(null) instanceof Inet6Address;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    static {
        System.setProperty("apple.awt.UIElement", "true");
    }

    public static class Jndi
    implements InitialContextFactory,
    InvocationHandler {
        @Override
        @NotNull
        public Context getInitialContext(Hashtable<?, ?> environment) {
            Context context = (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)this);
            if (context == null) {
                Jndi.$$$reportNull$$$0(0);
            }
            return context;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
            if (method == null) {
                Jndi.$$$reportNull$$$0(1);
            }
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            throw new NamingException("JNDI service is disabled");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/rmi/RemoteServer$Jndi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitialContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/rmi/RemoteServer$Jndi";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

