/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.CollaborationToolsIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.GithubIcons;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHGitRefName;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRAssignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRBaseRefChangedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRBaseRefForcePushedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRConnectedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRConvertToDraftEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRCrossReferencedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRDisconnectedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefDeletedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefForcePushedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefRestoredEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRLabeledEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRMergedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReadyForReviewEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReferencedSubject;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRRenamedTitleEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewDismissedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewRequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewUnrequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnassignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnlabeledEvent;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory$WhenMappings;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedSimpleEvents;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedStateEvents;
import org.jetbrains.plugins.github.ui.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\b\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;)V", "branchEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory;", "complexEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$ComplexEventComponentFactory;", "simpleEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory;", "stateEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory;", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "throwUnknownType", "", "item", "BranchEventComponentFactory", "Companion", "ComplexEventComponentFactory", "EventComponentFactory", "SimpleEventComponentFactory", "StateEventComponentFactory", "intellij.vcs.github"})
public final class GHPRTimelineEventComponentFactoryImpl
implements GHPRTimelineEventComponentFactory<GHPRTimelineEvent> {
    private final SimpleEventComponentFactory simpleEventDelegate;
    private final StateEventComponentFactory stateEventDelegate;
    private final BranchEventComponentFactory branchEventDelegate;
    private final ComplexEventComponentFactory complexEventDelegate;
    private final GHAvatarIconsProvider avatarIconsProvider;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent event) {
        GHPRTimelineItemComponentFactory.Item item2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GHPRTimelineEvent gHPRTimelineEvent = event;
        if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Simple) {
            item2 = this.simpleEventDelegate.createComponent((GHPRTimelineEvent.Simple)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.State) {
            item2 = this.stateEventDelegate.createComponent((GHPRTimelineEvent.State)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Branch) {
            item2 = this.branchEventDelegate.createComponent((GHPRTimelineEvent.Branch)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Complex) {
            item2 = this.complexEventDelegate.createComponent((GHPRTimelineEvent.Complex)event);
        } else {
            Void void_ = this.throwUnknownType(event);
            throw new KotlinNothingValueException();
        }
        return item2;
    }

    private final Void throwUnknownType(GHPRTimelineEvent item2) {
        throw (Throwable)new IllegalStateException("Unknown event type \"" + item2.getClass().getCanonicalName() + "\"");
    }

    public GHPRTimelineEventComponentFactoryImpl(@NotNull GHAvatarIconsProvider avatarIconsProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)avatarIconsProvider), (String)"avatarIconsProvider");
        this.avatarIconsProvider = avatarIconsProvider;
        this.simpleEventDelegate = new SimpleEventComponentFactory();
        this.stateEventDelegate = new StateEventComponentFactory();
        this.branchEventDelegate = new BranchEventComponentFactory();
        this.complexEventDelegate = new ComplexEventComponentFactory();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00a2\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0004\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "T", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "eventItem", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "markerIcon", "Ljavax/swing/Icon;", "item", "titleHTML", "", "intellij.vcs.github"})
    private abstract class EventComponentFactory<T extends GHPRTimelineEvent>
    implements GHPRTimelineEventComponentFactory<T> {
        @NotNull
        protected final GHPRTimelineItemComponentFactory.Item eventItem(@NotNull GHPRTimelineEvent item2, @Language(value="HTML") @NotNull String titleHTML) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            Intrinsics.checkNotNullParameter((Object)titleHTML, (String)"titleHTML");
            Icon icon = GithubIcons.Timeline;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Timeline");
            return this.eventItem(icon, item2, titleHTML);
        }

        @NotNull
        protected final GHPRTimelineItemComponentFactory.Item eventItem(@NotNull Icon markerIcon, @NotNull GHPRTimelineEvent item2, @Language(value="HTML") @NotNull String titleHTML) {
            Intrinsics.checkNotNullParameter((Object)markerIcon, (String)"markerIcon");
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            Intrinsics.checkNotNullParameter((Object)titleHTML, (String)"titleHTML");
            return new GHPRTimelineItemComponentFactory.Item(markerIcon, GHPRTimelineItemComponentFactory.Companion.actionTitle(GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider, item2.getActor(), titleHTML, item2.getCreatedAt()), null, null, 12, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\u00062\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002J\"\u0010\u0014\u001a\f0\u0006\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J,\u0010\u0019\u001a\u00020\u00062\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\b2\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "assigneesHTML", "", "assigned", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "unassigned", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "labelHTML", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "labelsHTML", "added", "removed", "renameHTML", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "oldName", "newName", "reviewersHTML", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "intellij.vcs.github"})
    private final class SimpleEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Simple> {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.Simple event) {
            GHPRTimelineItemComponentFactory.Item item2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            GHPRTimelineEvent.Simple simple = event;
            if (simple instanceof GHPRAssignedEvent) {
                item2 = this.eventItem(event, SimpleEventComponentFactory.assigneesHTML$default(this, CollectionsKt.listOf((Object)((GHPRAssignedEvent)event).getUser()), null, 2, null));
            } else if (simple instanceof GHPRUnassignedEvent) {
                item2 = this.eventItem(event, SimpleEventComponentFactory.assigneesHTML$default(this, null, CollectionsKt.listOf((Object)((GHPRUnassignedEvent)event).getUser()), 1, null));
            } else if (simple instanceof GHPRReviewRequestedEvent) {
                item2 = this.eventItem(event, SimpleEventComponentFactory.reviewersHTML$default(this, CollectionsKt.listOf((Object)((GHPRReviewRequestedEvent)event).getRequestedReviewer()), null, 2, null));
            } else if (simple instanceof GHPRReviewUnrequestedEvent) {
                item2 = this.eventItem(event, SimpleEventComponentFactory.reviewersHTML$default(this, null, CollectionsKt.listOf((Object)((GHPRReviewUnrequestedEvent)event).getRequestedReviewer()), 1, null));
            } else if (simple instanceof GHPRLabeledEvent) {
                item2 = this.eventItem(event, SimpleEventComponentFactory.labelsHTML$default(this, CollectionsKt.listOf((Object)((GHPRLabeledEvent)event).getLabel()), null, 2, null));
            } else if (simple instanceof GHPRUnlabeledEvent) {
                item2 = this.eventItem(event, SimpleEventComponentFactory.labelsHTML$default(this, null, CollectionsKt.listOf((Object)((GHPRUnlabeledEvent)event).getLabel()), 1, null));
            } else if (simple instanceof GHPRRenamedTitleEvent) {
                item2 = this.eventItem(event, this.renameHTML(((GHPRRenamedTitleEvent)event).getPreviousTitle(), ((GHPRRenamedTitleEvent)event).getCurrentTitle()));
            } else if (simple instanceof GHPRTimelineMergedSimpleEvents) {
                void $this$apply;
                Object object;
                String string;
                Object object2;
                Object it;
                Object object3;
                Companion companion = Companion;
                StringBuilder stringBuilder = Companion.appendParagraph(Companion.appendParagraph(Companion.appendParagraph(new StringBuilder(), this.labelsHTML((Collection<GHLabel>)((GHPRTimelineMergedSimpleEvents)event).getAddedLabels(), (Collection<GHLabel>)((GHPRTimelineMergedSimpleEvents)event).getRemovedLabels())), this.assigneesHTML((Collection<GHUser>)((GHPRTimelineMergedSimpleEvents)event).getAssignedPeople(), (Collection<GHUser>)((GHPRTimelineMergedSimpleEvents)event).getUnassignedPeople())), this.reviewersHTML((Collection<? extends GHPullRequestRequestedReviewer>)((GHPRTimelineMergedSimpleEvents)event).getAddedReviewers(), (Collection<? extends GHPullRequestRequestedReviewer>)((GHPRTimelineMergedSimpleEvents)event).getRemovedReviewers()));
                Pair<String, String> pair = ((GHPRTimelineMergedSimpleEvents)event).getRename();
                if (pair != null) {
                    Pair<String, String> pair2 = object3 = pair;
                    StringBuilder stringBuilder2 = stringBuilder;
                    Companion companion2 = companion;
                    boolean bl = false;
                    object2 = this.renameHTML((String)it.getFirst(), (String)it.getSecond());
                    companion = companion2;
                    stringBuilder = stringBuilder2;
                    string = object2;
                } else {
                    string = null;
                }
                if ((object = (object3 = string)) == null) {
                    object = "";
                }
                StringBuilder builder = companion.appendParagraph(stringBuilder, object);
                Icon icon = GithubIcons.Timeline;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Timeline");
                JComponent jComponent = GHPRTimelineItemComponentFactory.Companion.actionTitle(GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider, event.getActor(), "", event.getCreatedAt());
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
                it = object3 = new HtmlEditorPane(string2);
                JComponent jComponent2 = jComponent;
                object2 = icon;
                boolean bl = false;
                $this$apply.setBorder((Border)JBUI.Borders.emptyLeft((int)28));
                $this$apply.setForeground(UIUtil.getContextHelpForeground());
                Unit unit = Unit.INSTANCE;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 8;
                Dimension dimension = null;
                JComponent jComponent3 = (JComponent)object3;
                JComponent jComponent4 = jComponent2;
                Object object4 = object2;
                item2 = new GHPRTimelineItemComponentFactory.Item((Icon)object4, jComponent4, jComponent3, dimension, n, defaultConstructorMarker);
            } else {
                Void void_ = GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw new KotlinNothingValueException();
            }
            return item2;
        }

        private final String assigneesHTML(Collection<GHUser> assigned, Collection<GHUser> unassigned) {
            StringBuilder builder = new StringBuilder();
            Object object = assigned;
            if (!object.isEmpty()) {
                builder.append(CollectionsKt.joinToString$default((Iterable)assigned, null, (CharSequence)(GithubBundle.message("pull.request.timeline.assigned", new Object[0]) + " "), null, (int)0, null, (Function1)assigneesHTML.1.INSTANCE, (int)29, null));
            }
            if (!(object = unassigned).isEmpty()) {
                object = builder;
                if (object.length() > 0) {
                    builder.append(" " + GithubBundle.message("pull.request.timeline.and", new Object[0]) + " ");
                }
                builder.append(CollectionsKt.joinToString$default((Iterable)unassigned, null, (CharSequence)(GithubBundle.message("pull.request.timeline.unassigned", new Object[0]) + " "), null, (int)0, null, (Function1)assigneesHTML.2.INSTANCE, (int)29, null));
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        static /* synthetic */ String assigneesHTML$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.assigneesHTML(collection, collection2);
        }

        private final String reviewersHTML(Collection<? extends GHPullRequestRequestedReviewer> added, Collection<? extends GHPullRequestRequestedReviewer> removed) {
            StringBuilder builder = new StringBuilder();
            Object object = added;
            if (!object.isEmpty()) {
                builder.append(CollectionsKt.joinToString$default((Iterable)added, null, (CharSequence)(GithubBundle.message("pull.request.timeline.requested.review", new Object[0]) + " "), null, (int)0, null, (Function1)reviewersHTML.1.INSTANCE, (int)29, null));
            }
            if (!(object = removed).isEmpty()) {
                object = builder;
                if (object.length() > 0) {
                    builder.append(" " + GithubBundle.message("pull.request.timeline.and", new Object[0]) + " ");
                }
                builder.append(CollectionsKt.joinToString$default((Iterable)removed, null, (CharSequence)(GithubBundle.message("pull.request.timeline.removed.review.request", new Object[0]) + " "), null, (int)0, null, (Function1)reviewersHTML.2.INSTANCE, (int)29, null));
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        static /* synthetic */ String reviewersHTML$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.reviewersHTML(collection, collection2);
        }

        private final String labelsHTML(Collection<GHLabel> added, Collection<GHLabel> removed) {
            StringBuilder builder = new StringBuilder();
            Object object = added;
            if (!object.isEmpty()) {
                if (added.size() > 1) {
                    builder.append(CollectionsKt.joinToString$default((Iterable)added, null, (CharSequence)(GithubBundle.message("pull.request.timeline.added.labels", new Object[0]) + " "), null, (int)0, null, (Function1)((Function1)new Function1<GHLabel, CharSequence>(this){
                        final /* synthetic */ SimpleEventComponentFactory this$0;

                        @NotNull
                        public final CharSequence invoke(@NotNull GHLabel it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return SimpleEventComponentFactory.access$labelHTML(this.this$0, it);
                        }
                        {
                            this.this$0 = simpleEventComponentFactory;
                            super(1);
                        }
                    }), (int)29, null));
                } else {
                    builder.append(GithubBundle.message("pull.request.timeline.added.label", this.labelHTML((GHLabel)CollectionsKt.first((Iterable)added))));
                }
            }
            if (!(object = removed).isEmpty()) {
                object = builder;
                if (object.length() > 0) {
                    builder.append(" " + GithubBundle.message("pull.request.timeline.and", new Object[0]) + " ");
                }
                if (removed.size() > 1) {
                    builder.append(CollectionsKt.joinToString$default((Iterable)removed, null, (CharSequence)(GithubBundle.message("pull.request.timeline.removed.labels", new Object[0]) + " "), null, (int)0, null, (Function1)((Function1)new Function1<GHLabel, CharSequence>(this){
                        final /* synthetic */ SimpleEventComponentFactory this$0;

                        @NotNull
                        public final CharSequence invoke(@NotNull GHLabel it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return SimpleEventComponentFactory.access$labelHTML(this.this$0, it);
                        }
                        {
                            this.this$0 = simpleEventComponentFactory;
                            super(1);
                        }
                    }), (int)29, null));
                } else {
                    builder.append(GithubBundle.message("pull.request.timeline.removed.label", this.labelHTML((GHLabel)CollectionsKt.first((Iterable)removed))));
                }
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        static /* synthetic */ String labelsHTML$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.labelsHTML(collection, collection2);
        }

        private final String labelHTML(GHLabel label2) {
            JBColor background = GHUIUtil.INSTANCE.getLabelBackground(label2);
            Color foreground = GHUIUtil.INSTANCE.getLabelForeground((Color)background);
            return "<span style='color: #" + ColorUtil.toHex((Color)foreground) + "; background: #" + ColorUtil.toHex((Color)((Color)background)) + "'>\n                  &nbsp;" + StringUtil.escapeXmlEntities((String)label2.getName()) + "&nbsp;</span>";
        }

        private final String renameHTML(String oldName, String newName) {
            String string = GithubBundle.message("pull.request.timeline.renamed", oldName, newName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026named\", oldName, newName)");
            return string;
        }

        public static final /* synthetic */ String access$labelHTML(SimpleEventComponentFactory $this, GHLabel label2) {
            return $this.labelHTML(label2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$State;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "intellij.vcs.github"})
    private final class StateEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.State> {
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.State event) {
            String string;
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            switch (GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory$WhenMappings.$EnumSwitchMapping$0[event.getNewState().ordinal()]) {
                case 1: {
                    icon = CollaborationToolsIcons.PullRequestClosed;
                    break;
                }
                case 2: {
                    icon = GithubIcons.PullRequestMerged;
                    break;
                }
                case 3: {
                    icon = CollaborationToolsIcons.PullRequestOpen;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"when (event.newState) {\n\u2026s.PullRequestOpen\n      }");
            Icon icon2 = icon;
            switch (GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory$WhenMappings.$EnumSwitchMapping$1[event.getNewState().ordinal()]) {
                case 1: {
                    string = GithubBundle.message("pull.request.timeline.closed", new Object[0]);
                    break;
                }
                case 2: {
                    GHPRTimelineEvent.State state2 = event instanceof GHPRTimelineMergedStateEvents ? ((GHPRTimelineMergedStateEvents)event).getLastStateEvent() : event;
                    if (state2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRMergedEvent");
                    }
                    GHPRMergedEvent mergeEvent = (GHPRMergedEvent)state2;
                    if (mergeEvent.getCommit() != null) {
                        String commitText = "<a href='" + mergeEvent.getCommit().getUrl() + "'>" + mergeEvent.getCommit().getAbbreviatedOid() + "</a>";
                        String ref = Companion.branchHTML(mergeEvent.getMergeRefName());
                        string = GithubBundle.message("pull.request.timeline.merged.commit", commitText, ref);
                        break;
                    }
                    string = GithubBundle.message("pull.request.timeline.merged", new Object[0]);
                    break;
                }
                case 3: {
                    string = GithubBundle.message("pull.request.timeline.reopened", new Object[0]);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (event.newState) {\n\u2026meline.reopened\")\n      }");
            String text = string;
            return this.eventItem(icon2, event, text);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Branch;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "branchHTML", "", "ref", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHGitRefName;", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "intellij.vcs.github"})
    private final class BranchEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Branch> {
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.Branch event) {
            GHPRTimelineItemComponentFactory.Item item2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            GHPRTimelineEvent.Branch branch = event;
            if (branch instanceof GHPRBaseRefChangedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.changed.base.branch", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026ine.changed.base.branch\")");
                item2 = this.eventItem(gHPRTimelineEvent, string);
            } else if (branch instanceof GHPRBaseRefForcePushedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                Object[] objectArray = new Object[1];
                String string = this.branchHTML(((GHPRBaseRefForcePushedEvent)event).getRef());
                if (string == null) {
                    string = "base";
                }
                objectArray[0] = string;
                String string2 = GithubBundle.message("pull.request.timeline.branch.force.pushed", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GithubBundle.message(\"pu\u2026TML(event.ref) ?: \"base\")");
                item2 = this.eventItem(gHPRTimelineEvent, string2);
            } else if (branch instanceof GHPRHeadRefForcePushedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                Object[] objectArray = new Object[1];
                String string = this.branchHTML(((GHPRHeadRefForcePushedEvent)event).getRef());
                if (string == null) {
                    string = "head";
                }
                objectArray[0] = string;
                String string3 = GithubBundle.message("pull.request.timeline.branch.force.pushed", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GithubBundle.message(\"pu\u2026TML(event.ref) ?: \"head\")");
                item2 = this.eventItem(gHPRTimelineEvent, string3);
            } else if (branch instanceof GHPRHeadRefDeletedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.branch.deleted", Companion.branchHTML(((GHPRHeadRefDeletedEvent)event).getHeadRefName()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026hHTML(event.headRefName))");
                item2 = this.eventItem(gHPRTimelineEvent, string);
            } else if (branch instanceof GHPRHeadRefRestoredEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                String string = GithubBundle.message("pull.request.timeline.branch.head.restored", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026ne.branch.head.restored\")");
                item2 = this.eventItem(gHPRTimelineEvent, string);
            } else {
                Void void_ = GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw new KotlinNothingValueException();
            }
            return item2;
        }

        private final String branchHTML(GHGitRefName ref) {
            String string;
            Object object = ref;
            if (object != null && (object = ((GHGitRefName)object).getName()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                string = Companion.branchHTML((String)it);
            } else {
                string = null;
            }
            return string;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$ComplexEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Complex;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "intellij.vcs.github"})
    private final class ComplexEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Complex> {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.Complex event) {
            GHPRTimelineItemComponentFactory.Item item2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            GHPRTimelineEvent.Complex complex = event;
            if (complex instanceof GHPRReviewDismissedEvent) {
                HtmlEditorPane htmlEditorPane;
                Icon icon = GithubIcons.Timeline;
                Icon icon2 = icon;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Timeline");
                GHAvatarIconsProvider gHAvatarIconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
                GHActor gHActor = event.getActor();
                Object[] objectArray = new Object[1];
                Object object = ((GHPRReviewDismissedEvent)event).getReviewAuthor();
                if (object == null || (object = object.getLogin()) == null) {
                    String string = GithubBundle.message("pull.request.timeline.stale.review.author", new Object[0]);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026ine.stale.review.author\")");
                }
                objectArray[0] = object;
                String string = GithubBundle.message("pull.request.timeline.stale.review.dismissed", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\n  \u2026ne.stale.review.author\"))");
                JComponent jComponent = GHPRTimelineItemComponentFactory.Companion.actionTitle(gHAvatarIconsProvider, gHActor, string, event.getCreatedAt());
                String string2 = ((GHPRReviewDismissedEvent)event).getDismissalMessageHTML();
                if (string2 != null) {
                    void it;
                    HtmlEditorPane htmlEditorPane2;
                    String string3;
                    String string4 = string3 = string2;
                    JComponent jComponent2 = jComponent;
                    Icon icon3 = icon2;
                    boolean bl = false;
                    HtmlEditorPane $this$apply = htmlEditorPane2 = new HtmlEditorPane((String)it);
                    boolean bl2 = false;
                    $this$apply.setBorder((Border)JBUI.Borders.emptyLeft((int)28));
                    HtmlEditorPane htmlEditorPane3 = htmlEditorPane2;
                    icon2 = icon3;
                    jComponent = jComponent2;
                    htmlEditorPane = htmlEditorPane3;
                } else {
                    htmlEditorPane = null;
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 8;
                Dimension dimension = null;
                JComponent jComponent3 = (JComponent)((Object)htmlEditorPane);
                JComponent jComponent4 = jComponent;
                Icon icon4 = icon2;
                item2 = new GHPRTimelineItemComponentFactory.Item(icon4, jComponent4, jComponent3, dimension, n, defaultConstructorMarker);
            } else if (complex instanceof GHPRReadyForReviewEvent) {
                Icon icon = GithubIcons.Review;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Review");
                GHAvatarIconsProvider gHAvatarIconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
                GHActor gHActor = event.getActor();
                String string = GithubBundle.message("pull.request.timeline.marked.as.ready", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026imeline.marked.as.ready\")");
                item2 = new GHPRTimelineItemComponentFactory.Item(icon, GHPRTimelineItemComponentFactory.Companion.actionTitle(gHAvatarIconsProvider, gHActor, string, event.getCreatedAt()), null, null, 12, null);
            } else if (complex instanceof GHPRConvertToDraftEvent) {
                Icon icon = GithubIcons.Review;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Review");
                GHAvatarIconsProvider gHAvatarIconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
                GHActor gHActor = event.getActor();
                String string = GithubBundle.message("pull.request.timeline.marked.as.draft", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026imeline.marked.as.draft\")");
                item2 = new GHPRTimelineItemComponentFactory.Item(icon, GHPRTimelineItemComponentFactory.Companion.actionTitle(gHAvatarIconsProvider, gHActor, string, event.getCreatedAt()), null, null, 12, null);
            } else if (complex instanceof GHPRCrossReferencedEvent) {
                Icon icon = GithubIcons.Timeline;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Timeline");
                GHAvatarIconsProvider gHAvatarIconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
                GHActor gHActor = event.getActor();
                String string = GithubBundle.message("pull.request.timeline.mentioned", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026uest.timeline.mentioned\")");
                item2 = new GHPRTimelineItemComponentFactory.Item(icon, GHPRTimelineItemComponentFactory.Companion.actionTitle(gHAvatarIconsProvider, gHActor, string, event.getCreatedAt()), Companion.createComponent(((GHPRCrossReferencedEvent)event).getSource()), null, 8, null);
            } else if (complex instanceof GHPRConnectedEvent) {
                Icon icon = GithubIcons.Timeline;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Timeline");
                GHAvatarIconsProvider gHAvatarIconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
                GHActor gHActor = event.getActor();
                String string = GithubBundle.message("pull.request.timeline.connected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026uest.timeline.connected\")");
                item2 = new GHPRTimelineItemComponentFactory.Item(icon, GHPRTimelineItemComponentFactory.Companion.actionTitle(gHAvatarIconsProvider, gHActor, string, event.getCreatedAt()), Companion.createComponent(((GHPRConnectedEvent)event).getSubject()), null, 8, null);
            } else if (complex instanceof GHPRDisconnectedEvent) {
                Icon icon = GithubIcons.Timeline;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GithubIcons.Timeline");
                GHAvatarIconsProvider gHAvatarIconsProvider = GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider;
                GHActor gHActor = event.getActor();
                String string = GithubBundle.message("pull.request.timeline.disconnected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GithubBundle.message(\"pu\u2026t.timeline.disconnected\")");
                item2 = new GHPRTimelineItemComponentFactory.Item(icon, GHPRTimelineItemComponentFactory.Companion.actionTitle(gHAvatarIconsProvider, gHActor, string, event.getCreatedAt()), Companion.createComponent(((GHPRDisconnectedEvent)event).getSubject()), null, 8, null);
            } else {
                Void void_ = GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw new KotlinNothingValueException();
            }
            return item2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00060\u000bj\u0002`\f*\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$Companion;", "", "()V", "branchHTML", "", "name", "createComponent", "Ljavax/swing/JComponent;", "reference", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRReferencedSubject;", "appendParagraph", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "intellij.vcs.github"})
    public static final class Companion {
        private final String branchHTML(String name) {
            JBColor foreground = CurrentBranchComponent.TEXT_COLOR;
            Color color2 = UIUtil.getListBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getListBackground()");
            Color background = CurrentBranchComponent.Companion.getBranchPresentationBackground(color2);
            return "<span style='color: #" + ColorUtil.toHex((Color)((Color)foreground)) + "; background: #" + ColorUtil.toHex((Color)background) + "'>\n                  &nbsp;<icon-inline src='icons.CollaborationToolsIcons.Branch'/>" + name + "&nbsp;</span>";
        }

        private final StringBuilder appendParagraph(StringBuilder $this$appendParagraph, String text) {
            CharSequence charSequence = text;
            if (charSequence.length() > 0) {
                $this$appendParagraph.append("<p>").append(text).append("</p>");
            }
            return $this$appendParagraph;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent createComponent(GHPRReferencedSubject reference) {
            void $this$apply;
            JLabel jLabel;
            String string;
            Icon icon;
            GHPRReferencedSubject gHPRReferencedSubject = reference;
            if (gHPRReferencedSubject instanceof GHPRReferencedSubject.Issue) {
                icon = GHUIUtil.INSTANCE.getIssueStateIcon(((GHPRReferencedSubject.Issue)reference).getState());
            } else if (gHPRReferencedSubject instanceof GHPRReferencedSubject.PullRequest) {
                icon = GHUIUtil.INSTANCE.getPullRequestStateIcon(((GHPRReferencedSubject.PullRequest)reference).getState(), ((GHPRReferencedSubject.PullRequest)reference).isDraft());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Icon stateIcon = icon;
            GHPRReferencedSubject gHPRReferencedSubject2 = reference;
            if (gHPRReferencedSubject2 instanceof GHPRReferencedSubject.Issue) {
                string = GHUIUtil.INSTANCE.getIssueStateText(((GHPRReferencedSubject.Issue)reference).getState());
            } else if (gHPRReferencedSubject2 instanceof GHPRReferencedSubject.PullRequest) {
                string = GHUIUtil.INSTANCE.getPullRequestStateText(((GHPRReferencedSubject.PullRequest)reference).getState(), ((GHPRReferencedSubject.PullRequest)reference).isDraft());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String stateToolTip = string;
            GHPRReferencedSubject $this$apply2 = gHPRReferencedSubject2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(5));
            boolean bl = false;
            $this$apply2.setBorder((Border)JBUI.Borders.emptyLeft((int)28));
            JLabel jLabel2 = jLabel = new JLabel(stateIcon);
            GHPRReferencedSubject gHPRReferencedSubject3 = $this$apply2;
            boolean bl2 = false;
            $this$apply.setToolTipText(stateToolTip);
            Unit unit = Unit.INSTANCE;
            gHPRReferencedSubject3.add(jLabel);
            $this$apply2.add((Component)((Object)new HtmlEditorPane(reference.getTitle() + "&nbsp<a href='" + reference.getUrl() + "'>#" + reference.getNumber() + "</a>")));
            return (JComponent)((Object)gHPRReferencedSubject2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

