/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import git4idea.DialogManager;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.ui.BaseLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHOAuthLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHTokenLoginDialog;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0016H\u0002\u001a\"\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\"\u0010\u001a\u001a\u0004\u0018\u00010\u0018*\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\u0018*\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\"L\u0010\u0000\u001a6\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0001j\u0002`\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u000b\u00a8\u0006\u001c"}, d2={"isLoginUniqueChecker", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "(Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;)Lkotlin/jvm/functions/Function2;", "promptOAuthLogin", "", "request", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "configure", "", "dialog", "Lorg/jetbrains/plugins/github/authentication/ui/BaseLoginDialog;", "getAuthData", "Lorg/jetbrains/plugins/github/authentication/GHAccountAuthData;", "loginWithOAuth", "loginWithOAuthOrToken", "loginWithToken", "intellij.vcs.github"})
public final class GHLoginRequestKt {
    @Nullable
    public static final GHAccountAuthData loginWithToken(@NotNull GHLoginRequest $this$loginWithToken, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$loginWithToken, (String)"$this$loginWithToken");
        GHTokenLoginDialog dialog2 = new GHTokenLoginDialog(project, parentComponent, GHLoginRequestKt.isLoginUniqueChecker($this$loginWithToken));
        GHLoginRequestKt.configure($this$loginWithToken, dialog2);
        return GHLoginRequestKt.getAuthData(dialog2);
    }

    @Nullable
    public static final GHAccountAuthData loginWithOAuth(@NotNull GHLoginRequest $this$loginWithOAuth, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$loginWithOAuth, (String)"$this$loginWithOAuth");
        GHOAuthLoginDialog dialog2 = new GHOAuthLoginDialog(project, parentComponent, GHLoginRequestKt.isLoginUniqueChecker($this$loginWithOAuth));
        GHLoginRequestKt.configure($this$loginWithOAuth, dialog2);
        return GHLoginRequestKt.getAuthData(dialog2);
    }

    @Nullable
    public static final GHAccountAuthData loginWithOAuthOrToken(@NotNull GHLoginRequest $this$loginWithOAuthOrToken, @Nullable Project project, @Nullable Component parentComponent) {
        GHAccountAuthData gHAccountAuthData;
        Intrinsics.checkNotNullParameter((Object)$this$loginWithOAuthOrToken, (String)"$this$loginWithOAuthOrToken");
        switch (GHLoginRequestKt.promptOAuthLogin($this$loginWithOAuthOrToken, project, parentComponent)) {
            case 0: {
                gHAccountAuthData = GHLoginRequestKt.loginWithOAuth($this$loginWithOAuthOrToken, project, parentComponent);
                break;
            }
            case 1: {
                gHAccountAuthData = GHLoginRequestKt.loginWithToken($this$loginWithOAuthOrToken, project, parentComponent);
                break;
            }
            default: {
                gHAccountAuthData = null;
            }
        }
        return gHAccountAuthData;
    }

    private static final Function2<String, GithubServerPath, Boolean> isLoginUniqueChecker(GHLoginRequest $this$isLoginUniqueChecker) {
        return (Function2)new Function2<String, GithubServerPath, Boolean>($this$isLoginUniqueChecker){
            final /* synthetic */ GHLoginRequest $this_isLoginUniqueChecker;

            public final boolean invoke(@NotNull String login2, @NotNull GithubServerPath server) {
                Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return !this.$this_isLoginUniqueChecker.isCheckLoginUnique() || GithubAuthenticationManager.Companion.getInstance().isAccountUnique$intellij_vcs_github(login2, server);
            }
            {
                this.$this_isLoginUniqueChecker = gHLoginRequest;
                super(2);
            }
        };
    }

    private static final void configure(GHLoginRequest $this$configure, BaseLoginDialog dialog2) {
        block3: {
            Object it;
            Object object;
            Throwable throwable = $this$configure.getError();
            if (throwable != null) {
                it = object = throwable;
                boolean bl = false;
                dialog2.setError((Throwable)it);
            }
            GithubServerPath githubServerPath = $this$configure.getServer();
            if (githubServerPath != null) {
                it = object = githubServerPath;
                boolean bl = false;
                String string = ((GithubServerPath)it).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                dialog2.setServer(string, $this$configure.isServerEditable());
            }
            String string = $this$configure.getLogin();
            if (string != null) {
                it = object = string;
                boolean bl = false;
                dialog2.setLogin((String)it, $this$configure.isLoginEditable());
            }
            String string2 = $this$configure.getToken();
            if (string2 == null) break block3;
            it = object = string2;
            boolean bl = false;
            dialog2.setToken((String)it);
        }
    }

    private static final GHAccountAuthData getAuthData(BaseLoginDialog $this$getAuthData) {
        DialogManager.show((DialogWrapper)$this$getAuthData);
        return $this$getAuthData.isOK() ? new GHAccountAuthData(GHAccountManager.Companion.createAccount($this$getAuthData.getLogin(), $this$getAuthData.getServer()), $this$getAuthData.getLogin(), $this$getAuthData.getToken()) : null;
    }

    private static final int promptOAuthLogin(GHLoginRequest request, Project project, Component parentComponent) {
        String string = GithubBundle.message("login.to.github", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"login.to.github\")");
        String string2 = request.getText();
        if (string2 == null) {
            String string3 = GithubBundle.message("dialog.message.login.to.continue", new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"dialog.message.login.to.continue\")");
        }
        MessageDialogBuilder.YesNoCancel yesNoCancel = MessageDialogBuilder.Companion.yesNoCancel(string, string2);
        String string4 = GithubBundle.message("login.via.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"login.via.github.action\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string4);
        String string5 = GithubBundle.message("button.use.token", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"button.use.token\")");
        MessageDialogBuilder.YesNoCancel builder = (MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel2.noText(string5)).icon(Messages.getWarningIcon());
        if (parentComponent != null) {
            return builder.show(parentComponent);
        }
        return builder.show(project);
    }
}

