/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import io.prometheus.client.Gauge;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LtThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(LtThreadPoolExecutor.class);
    private static final Gauge maxQueueSize = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_threadpool_max_queue_size", (String)"Queue capacity by threadpool").labelNames(new String[]{"pool"})).register();
    private static final Gauge queueSize = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_threadpool_queue_size", (String)"Queue size by threadpool").labelNames(new String[]{"pool"})).register();
    private static final Gauge largestPoolSize = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_threadpool_largest_queue_size", (String)"The largest number of threads that have ever simultaneously been in the pool").labelNames(new String[]{"pool"})).register();
    private final String name;

    LtThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull ThreadFactory threadFactory, @NotNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        Timer timer = new Timer("LtThreadPoolExecutorMonitor", true);
        TimerTask timedAction = new TimerTask(){

            @Override
            public void run() {
                ((Gauge.Child)queueSize.labels(new String[]{LtThreadPoolExecutor.this.name})).set((double)LtThreadPoolExecutor.this.getQueue().size());
                ((Gauge.Child)largestPoolSize.labels(new String[]{LtThreadPoolExecutor.this.name})).set((double)LtThreadPoolExecutor.this.getLargestPoolSize());
                log.trace("{} queueSize: {}", (Object)LtThreadPoolExecutor.this.name, (Object)((Gauge.Child)queueSize.labels(new String[]{LtThreadPoolExecutor.this.name})).get());
                log.trace("{} largestPoolSize: {}", (Object)LtThreadPoolExecutor.this.name, (Object)((Gauge.Child)largestPoolSize.labels(new String[]{LtThreadPoolExecutor.this.name})).get());
            }
        };
        timer.scheduleAtFixedRate(timedAction, 0L, 1000L);
        this.name = name;
        ((Gauge.Child)maxQueueSize.labels(new String[]{name})).set((double)workQueue.remainingCapacity());
    }

    @Override
    public void execute(@NotNull Runnable command2) {
        super.execute(command2);
    }

    @Override
    public boolean remove(Runnable task) {
        return super.remove(task);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null && t instanceof OutOfMemoryError) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
    }

    public String getName() {
        return this.name;
    }
}

