/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.export;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.core.EditorConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigSettingsWriter
extends OutputStreamWriter {
    private final CodeStyleSettings mySettings;
    @Nullable
    private final Project myProject;
    private final Map<String, String> myGeneralOptions;
    private final boolean myAddRootFlag;
    private final boolean myCommentOutProperties;
    private boolean myNoHeaders;
    private static final Comparator<EditorConfig.OutPair> PAIR_COMPARATOR = (pair1, pair2) -> {
        EditorConfigPropertyKind pKind2;
        EditorConfigPropertyKind pKind1 = EditorConfigSettingsWriter.getPropertyKind(pair1.getKey());
        if (!pKind1.equals((Object)(pKind2 = EditorConfigSettingsWriter.getPropertyKind(pair2.getKey())))) {
            return Comparing.compare((Comparable)((Object)pKind2), (Comparable)((Object)pKind1));
        }
        return Comparing.compare((Comparable)((Object)pair1.getKey()), (Comparable)((Object)pair2.getKey()));
    };
    private Set<Language> myLanguages;
    private final Set<EditorConfigPropertyKind> myPropertyKinds;

    public EditorConfigSettingsWriter(@Nullable Project project, @NotNull OutputStream out, CodeStyleSettings settings, boolean isRoot, boolean commentOutProperties) {
        if (out == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(0);
        }
        super(out, StandardCharsets.UTF_8);
        this.myGeneralOptions = new HashMap<String, String>();
        this.myPropertyKinds = EnumSet.allOf(EditorConfigPropertyKind.class);
        this.mySettings = settings;
        this.myProject = project;
        this.myAddRootFlag = isRoot;
        this.myCommentOutProperties = commentOutProperties;
        this.fillGeneralOptions();
    }

    private void fillGeneralOptions() {
        String lineSeparator;
        String encoding;
        for (EditorConfig.OutPair pair : this.getKeyValuePairs((AbstractCodeStylePropertyMapper)new GeneralCodeStylePropertyMapper(this.mySettings))) {
            this.myGeneralOptions.put(pair.getKey(), pair.getVal());
        }
        this.myGeneralOptions.put("ij_continuation_indent_size", String.valueOf(this.mySettings.OTHER_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE));
        if (this.myProject != null && (encoding = Utils.getEncoding(this.myProject)) != null) {
            this.myGeneralOptions.put("charset", encoding);
        }
        if ((lineSeparator = Utils.getLineSeparatorString(this.mySettings.getLineSeparator())) != null) {
            this.myGeneralOptions.put("end_of_line", lineSeparator);
        }
        this.myGeneralOptions.put("insert_final_newline", String.valueOf(EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF()));
        Boolean trimSpaces = Utils.getTrimTrailingSpaces();
        if (trimSpaces != null) {
            this.myGeneralOptions.put("trim_trailing_whitespace", String.valueOf(trimSpaces));
        }
    }

    public EditorConfigSettingsWriter forLanguages(List<Language> languages) {
        this.myLanguages = new HashSet<Language>(languages.size());
        this.myLanguages.addAll(languages);
        return this;
    }

    public EditorConfigSettingsWriter forLanguages(Language ... languages) {
        this.myLanguages = new HashSet<Language>(languages.length);
        this.myLanguages.addAll(Arrays.asList(languages));
        return this;
    }

    public EditorConfigSettingsWriter forPropertyKinds(EditorConfigPropertyKind ... kinds) {
        this.myPropertyKinds.clear();
        this.myPropertyKinds.addAll(Arrays.asList(kinds));
        return this;
    }

    public EditorConfigSettingsWriter withoutHeaders() {
        this.myNoHeaders = true;
        return this;
    }

    public void writeSettings() throws IOException {
        if (this.myAddRootFlag) {
            this.writeProperties(Collections.singletonList(new EditorConfig.OutPair("root", "true")), false);
            this.write("\n");
        }
        this.writeGeneralSection();
        MultiMap mappers = new MultiMap();
        CodeStylePropertiesUtil.collectMappers((CodeStyleSettings)this.mySettings, mapper -> {
            LanguageFileType fileType;
            if (mapper instanceof LanguageCodeStylePropertyMapper && (fileType = ((LanguageCodeStylePropertyMapper)mapper).getLanguage().getAssociatedFileType()) != null) {
                String pattern = Utils.buildPattern((FileType)fileType);
                mappers.putValue((Object)pattern, (Object)((LanguageCodeStylePropertyMapper)mapper));
            }
        });
        for (String pattern : mappers.keySet().stream().sorted().collect(Collectors.toList())) {
            if (pattern.isEmpty()) continue;
            String currPattern = pattern;
            for (LanguageCodeStylePropertyMapper mapper2 : mappers.get((Object)pattern).stream().sorted(Comparator.comparing(mapper -> mapper.getLanguageDomainId())).collect(Collectors.toList())) {
                if (!this.writeLangSection(mapper2, currPattern)) continue;
                currPattern = null;
            }
        }
    }

    private void writeGeneralSection() throws IOException {
        if (!this.myNoHeaders) {
            this.write("[*]\n");
        }
        List<EditorConfig.OutPair> pairs = this.myGeneralOptions.keySet().stream().map(key -> new EditorConfig.OutPair((String)key, this.myGeneralOptions.get(key))).filter(pair -> this.isNameAllowed(pair.getKey())).sorted(PAIR_COMPARATOR).collect(Collectors.toList());
        this.writeProperties(pairs, this.myCommentOutProperties);
    }

    private boolean writeLangSection(@NotNull LanguageCodeStylePropertyMapper mapper, @Nullable String pattern) throws IOException {
        List<EditorConfig.OutPair> optionValueList;
        if (mapper == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(1);
        }
        Language language = mapper.getLanguage();
        if ((this.myLanguages == null || this.myLanguages.contains(language)) && !(optionValueList = this.getKeyValuePairs((AbstractCodeStylePropertyMapper)mapper)).isEmpty()) {
            if (pattern != null && !this.myNoHeaders) {
                this.write("\n[" + pattern + "]\n");
            }
            optionValueList.sort(PAIR_COMPARATOR);
            this.writeProperties(optionValueList, this.myCommentOutProperties);
            return true;
        }
        return false;
    }

    private List<EditorConfig.OutPair> getKeyValuePairs(@NotNull AbstractCodeStylePropertyMapper mapper) {
        if (mapper == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(2);
        }
        ArrayList<EditorConfig.OutPair> optionValueList = new ArrayList<EditorConfig.OutPair>();
        for (String property : mapper.enumProperties()) {
            String value;
            CodeStylePropertyAccessor accessor = mapper.getAccessor(property);
            String name = EditorConfigSettingsWriter.getEditorConfigName(mapper, property);
            if (!this.isNameAllowed(name) || !EditorConfigSettingsWriter.isValueAllowed(value = EditorConfigSettingsWriter.getEditorConfigValue(accessor)) || mapper instanceof LanguageCodeStylePropertyMapper && this.matchesGeneral(name, value)) continue;
            optionValueList.add(new EditorConfig.OutPair(name, value));
        }
        return optionValueList;
    }

    private static String getEditorConfigValue(@NotNull CodeStylePropertyAccessor<?> accessor) {
        String value;
        if (accessor == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(3);
        }
        if (((value = accessor.getAsString()) == null || value.isEmpty()) && CodeStylePropertiesUtil.isAccessorAllowingEmptyList(accessor)) {
            return "none";
        }
        return value;
    }

    private boolean matchesGeneral(@NotNull String name, @NotNull String value) {
        String generalValue;
        if (name == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(4);
        }
        if (value == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(5);
        }
        return (generalValue = this.myGeneralOptions.get(name)) != null && generalValue.equals(value);
    }

    private boolean isNameAllowed(@Nullable String ecName) {
        if (ecName != null) {
            return this.myPropertyKinds.contains((Object)EditorConfigSettingsWriter.getPropertyKind(ecName));
        }
        return false;
    }

    private static EditorConfigPropertyKind getPropertyKind(@NotNull String ecName) {
        if (ecName == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(6);
        }
        String ijName = EditorConfigIntellijNameUtil.toIntellijName(ecName);
        return IntellijPropertyKindMap.getPropertyKind(ijName);
    }

    private static boolean isValueAllowed(@Nullable String value) {
        return value != null && !value.trim().isEmpty();
    }

    private void writeProperties(@NotNull List<EditorConfig.OutPair> outPairs, boolean commentOut) throws IOException {
        if (outPairs == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(7);
        }
        for (EditorConfig.OutPair pair : outPairs) {
            if (commentOut) {
                this.write("# ");
            }
            this.write(pair.getKey() + " = " + pair.getVal() + "\n");
        }
    }

    @Nullable
    private static String getEditorConfigName(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        List<String> editorConfigNames;
        if (mapper == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            EditorConfigSettingsWriter.$$$reportNull$$$0(9);
        }
        if ((editorConfigNames = EditorConfigIntellijNameUtil.toEditorConfigNames(mapper, propertyName)).isEmpty()) {
            return null;
        }
        if (editorConfigNames.size() == 1) {
            return editorConfigNames.get(0);
        }
        return EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ecName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outPairs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/export/EditorConfigSettingsWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeLangSection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyValuePairs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorConfigValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesGeneral";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorConfigName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

