/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 *2\u00020\u0001:\u0001*B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002JD\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0019\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J-\u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001d2\u000b\u0010\u001e\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J1\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0#2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0019\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010$JQ\u0010%\u001a\u0004\u0018\u00010\u00162\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00162\u000e\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0#2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0019\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0007*\u00020\u000fH\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lgit4idea/history/GitFileHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "startingRevision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "Lorg/jetbrains/annotations/NotNull;", "createGitFileRevision", "Lgit4idea/GitFileRevision;", "record", "Lgit4idea/history/GitLogFullRecord;", "lastPath", "createLogHandler", "Lgit4idea/commands/GitLineHandler;", "parser", "Lgit4idea/history/GitLogParser;", "lastCommit", "", "Lorg/jetbrains/annotations/NonNls;", "parameters", "", "(Lgit4idea/history/GitLogParser;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;[Ljava/lang/String;)Lgit4idea/commands/GitLineHandler;", "createLogParser", "getFirstCommitParentAndPathIfRename", "Lkotlin/Pair;", "commit", "filePath", "load", "", "consumer", "Lcom/intellij/util/Consumer;", "(Lcom/intellij/util/Consumer;[Ljava/lang/String;)V", "runGitLog", "logParser", "startPath", "startRevision", "(Lgit4idea/history/GitLogParser;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;Lcom/intellij/util/Consumer;[Ljava/lang/String;)Ljava/lang/String;", "Companion", "intellij.vcs.git"})
public final class GitFileHistory {
    private final FilePath path;
    private final Project project;
    private final VirtualFile root;
    private final VcsRevisionNumber startingRevision;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void load(Consumer<? super GitFileRevision> consumer2, String ... parameters) throws VcsException {
        GitLogParser<GitLogFullRecord> logParser = this.createLogParser();
        String startRevision = this.startingRevision.asString();
        FilePath startPath = this.path;
        while (startRevision != null) {
            Pair<String, FilePath> firstCommitParentAndPath;
            String lastCommit;
            if (this.runGitLog(logParser, startPath, startRevision, consumer2, Arrays.copyOf(parameters, parameters.length)) == null) {
                return;
            }
            if (this.getFirstCommitParentAndPathIfRename(lastCommit, startPath) == null) {
                return;
            }
            startRevision = (String)firstCommitParentAndPath.getFirst();
            startPath = (FilePath)firstCommitParentAndPath.getSecond();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String runGitLog(GitLogParser<GitLogFullRecord> logParser, FilePath startPath, String startRevision, Consumer<? super GitFileRevision> consumer2, String ... parameters) throws VcsException {
        void lastCommit;
        void skipFurtherOutput;
        GitLineHandler handler = this.createLogHandler(logParser, startPath, startRevision, Arrays.copyOf(parameters, parameters.length));
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        GitLogOutputSplitter<GitLogFullRecord> splitter2 = new GitLogOutputSplitter<GitLogFullRecord>(handler, logParser, (Consumer)new Consumer(this, (Ref.BooleanRef)skipFurtherOutput, startPath, (Ref.ObjectRef)lastCommit, consumer2){
            final /* synthetic */ GitFileHistory this$0;
            final /* synthetic */ Ref.BooleanRef $skipFurtherOutput;
            final /* synthetic */ FilePath $startPath;
            final /* synthetic */ Ref.ObjectRef $lastCommit;
            final /* synthetic */ Consumer $consumer;

            public final void consume(GitLogFullRecord record) {
                if (this.$skipFurtherOutput.element) {
                    return;
                }
                GitLogFullRecord gitLogFullRecord = record;
                Intrinsics.checkNotNullExpressionValue((Object)gitLogFullRecord, (String)"record");
                List<VcsFileStatusInfo> list2 = gitLogFullRecord.getStatusInfos();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"record.statusInfos");
                VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
                if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.NEW && !GitFileHistory.access$getPath$p(this.this$0).isDirectory()) {
                    this.$skipFurtherOutput.element = true;
                }
                GitFileRevision revision = GitFileHistory.access$createGitFileRevision(this.this$0, record, this.$startPath);
                this.$lastCommit.element = record.getHash();
                this.$consumer.consume((Object)revision);
            }
            {
                this.this$0 = gitFileHistory;
                this.$skipFurtherOutput = booleanRef;
                this.$startPath = filePath;
                this.$lastCommit = objectRef;
                this.$consumer = consumer2;
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        splitter2.reportErrors();
        return (String)lastCommit.element;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, FilePath> getFirstCommitParentAndPathIfRename(String commit, FilePath filePath) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(this.project, this.root, GitCommand.SHOW);
        GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(this.project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"GitLogParser.createDefau\u2026    GitLogOption.PARENTS)");
        GitLogParser<GitLogFullRecord> parser = gitLogParser;
        h2.setStdoutSuppressed(true);
        h2.addParameters("-M", "-m", "--follow", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit);
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String output = string;
        List<GitLogFullRecord> list2 = parser.parse(output);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parser.parse(output)");
        List<GitLogFullRecord> records = list2;
        if (records.isEmpty()) {
            return null;
        }
        int n = 0;
        int n2 = ((Collection)records).size();
        while (n < n2) {
            List<Change> changes;
            void i;
            GitLogFullRecord record = records.get((int)i);
            Intrinsics.checkNotNullExpressionValue(record.parseChanges(this.project, this.root), (String)"record.parseChanges(project, root)");
            Iterator<Change> iterator = changes.iterator();
            while (iterator.hasNext()) {
                Change change;
                Change change2 = change = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)change2, (String)"change");
                if (!change2.isMoved() && !change.isRenamed()) continue;
                ContentRevision contentRevision = change.getAfterRevision();
                Intrinsics.checkNotNull((Object)contentRevision);
                Intrinsics.checkNotNullExpressionValue((Object)contentRevision, (String)"change.afterRevision!!");
                if (!Intrinsics.areEqual((Object)filePath, (Object)contentRevision.getFile())) continue;
                GitLogFullRecord gitLogFullRecord = record;
                Intrinsics.checkNotNullExpressionValue((Object)gitLogFullRecord, (String)"record");
                String[] parents = gitLogFullRecord.getParentsHashes();
                Intrinsics.checkNotNullExpressionValue((Object)parents, (String)"parents");
                String[] stringArray = parents;
                String parent = !(stringArray.length == 0) ? parents[i] : null;
                ContentRevision contentRevision2 = change.getBeforeRevision();
                Intrinsics.checkNotNull((Object)contentRevision2);
                Intrinsics.checkNotNullExpressionValue((Object)contentRevision2, (String)"change.beforeRevision!!");
                FilePath filePath2 = contentRevision2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"change.beforeRevision!!.file");
                return new Pair((Object)parent, (Object)filePath2);
            }
            ++i;
        }
        return null;
    }

    private final GitFileRevision createGitFileRevision(GitLogFullRecord record, FilePath lastPath) {
        GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
        Couple couple = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"Couple.of(record.authorName, record.authorEmail)");
        Couple authorPair = couple;
        Couple couple2 = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
        Intrinsics.checkNotNullExpressionValue((Object)couple2, (String)"Couple.of(record.committ\u2026e, record.committerEmail)");
        Couple committerPair = couple2;
        String[] stringArray = record.getParentsHashes();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"record.parentsHashes");
        List parents = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        FilePath filePath = this.filePath(record);
        if (filePath == null) {
            filePath = lastPath;
        }
        FilePath revisionPath = filePath;
        List<VcsFileStatusInfo> list2 = record.getStatusInfos();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"record.statusInfos");
        VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
        boolean deleted = (vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.DELETED;
        return new GitFileRevision(this.project, this.root, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents, deleted);
    }

    private final FilePath filePath(GitLogFullRecord $this$filePath) {
        List<VcsFileStatusInfo> list2 = $this$filePath.getStatusInfos();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"statusInfos");
        VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
        if (vcsFileStatusInfo == null) {
            return null;
        }
        VcsFileStatusInfo statusInfo = vcsFileStatusInfo;
        String string = this.root.getPath();
        String string2 = statusInfo.getSecondPath();
        if (string2 == null) {
            string2 = statusInfo.getFirstPath();
        }
        return VcsUtil.getFilePath((String)(string + "/" + string2), (boolean)false);
    }

    private final GitLineHandler createLogHandler(GitLogParser<GitLogFullRecord> parser, FilePath path, String lastCommit, String ... parameters) {
        String[] stringArray;
        GitLineHandler h2 = new GitLineHandler(this.project, this.root, GitCommand.LOG);
        h2.setStdoutSuppressed(true);
        h2.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.project) && Registry.is((String)"git.file.history.full")) {
            h2.addParameters("--full-history", "--simplify-merges");
        }
        if (!((stringArray = parameters).length == 0)) {
            h2.addParameters(Arrays.copyOf(parameters, parameters.length));
        }
        h2.endOptions();
        h2.addRelativePaths(path);
        return h2;
    }

    private final GitLogParser<GitLogFullRecord> createLogParser() {
        GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(this.project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"GitLogParser.createDefau\u2026GitLogOption.AUTHOR_TIME)");
        return gitLogParser;
    }

    private GitFileHistory(Project project, VirtualFile root, FilePath path, VcsRevisionNumber startingRevision) {
        this.project = project;
        this.root = root;
        this.startingRevision = startingRevision;
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.project, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getLastCommitPath(project, path)");
        this.path = filePath;
    }

    public static final /* synthetic */ FilePath access$getPath$p(GitFileHistory $this) {
        return $this.path;
    }

    public static final /* synthetic */ GitFileRevision access$createGitFileRevision(GitFileHistory $this, GitLogFullRecord record, FilePath lastPath) {
        return $this.createGitFileRevision(record, lastPath);
    }

    public /* synthetic */ GitFileHistory(Project project, VirtualFile root, FilePath path, VcsRevisionNumber startingRevision, DefaultConstructorMarker $constructor_marker) {
        this(project, root, path, startingRevision);
    }

    @JvmStatic
    public static final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
        Companion.loadHistory(project, path, startingFrom, consumer2, exceptionConsumer, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        return Companion.collectHistoryForRevision(project, path, startingFrom, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        return Companion.collectHistory(project, path, parameters);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0011J[\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u00152\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0019JK\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u00152\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lgit4idea/history/GitFileHistory$Companion;", "", "()V", "collectHistory", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "parameters", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;[Ljava/lang/String;)Ljava/util/List;", "collectHistoryForRevision", "startingFrom", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;[Ljava/lang/String;)Ljava/util/List;", "loadHistory", "", "consumer", "Lcom/intellij/util/Consumer;", "Lgit4idea/GitFileRevision;", "exceptionConsumer", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Lcom/intellij/util/Consumer;Lcom/intellij/util/Consumer;[Ljava/lang/String;)V", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Lcom/intellij/util/Consumer;[Ljava/lang/String;)V", "intellij.vcs.git"})
    public static final class Companion {
        private final void loadHistory(Project project, FilePath path, VcsRevisionNumber startingFrom, Consumer<? super GitFileRevision> consumer2, String ... parameters) {
            VcsRevisionNumber revision;
            VirtualFile virtualFile = GitUtil.getRootForFile(project, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"GitUtil.getRootForFile(project, path)");
            VirtualFile repositoryRoot = virtualFile;
            VcsRevisionNumber vcsRevisionNumber = startingFrom;
            if (vcsRevisionNumber == null) {
                vcsRevisionNumber = (VcsRevisionNumber)GitRevisionNumber.HEAD;
            }
            VcsRevisionNumber vcsRevisionNumber2 = revision = vcsRevisionNumber;
            Intrinsics.checkNotNullExpressionValue((Object)vcsRevisionNumber2, (String)"revision");
            new GitFileHistory(project, repositoryRoot, path, vcsRevisionNumber2, null).load((Consumer<? super GitFileRevision>)consumer2, Arrays.copyOf(parameters, parameters.length));
        }

        @JvmStatic
        public final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            Intrinsics.checkNotNullParameter(exceptionConsumer, (String)"exceptionConsumer");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            try {
                this.loadHistory(project, path, startingFrom, consumer2, Arrays.copyOf(parameters, parameters.length));
            }
            catch (VcsException e) {
                exceptionConsumer.consume((Object)e);
            }
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)startingFrom, (String)"startingFrom");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            List revisions = new ArrayList();
            Function1 function1 = (Function1)new Function1<VcsFileRevision, Unit>(revisions){

                public final void invoke(@NotNull VcsFileRevision p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((List)this.receiver).add(p1);
                }
            };
            this.loadHistory(project, path, startingFrom, (Consumer<? super GitFileRevision>)new Consumer(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void consume(Object p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
                }
            }, Arrays.copyOf(parameters, parameters.length));
            return revisions;
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.HEAD;
            Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"GitRevisionNumber.HEAD");
            return this.collectHistoryForRevision(project, path, (VcsRevisionNumber)gitRevisionNumber, Arrays.copyOf(parameters, parameters.length));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

