/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.util.containers.UtilKt;
import git4idea.GitBranch;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u000b\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0015\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0007R/\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u0007*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/actions/branch/GitBranchActionsUtil;", "", "()V", "BRANCHES_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "Lgit4idea/GitBranch;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "REPOSITORIES_KEY", "Lgit4idea/repo/GitRepository;", "calculateNewBranchInitialName", "", "Lcom/intellij/openapi/util/NlsSafe;", "branchName", "isRemote", "", "branch", "intellij.vcs.git"})
public final class GitBranchActionsUtil {
    @JvmField
    @NotNull
    public static final DataKey<List<GitRepository>> REPOSITORIES_KEY;
    @JvmField
    @NotNull
    public static final DataKey<List<GitBranch>> BRANCHES_KEY;
    @NotNull
    public static final GitBranchActionsUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final String calculateNewBranchInitialName(@NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        String string = branch.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"branch.name");
        return GitBranchActionsUtil.calculateNewBranchInitialName(string, branch.isRemote());
    }

    @JvmStatic
    @NotNull
    public static final String calculateNewBranchInitialName(@NotNull String branchName, boolean isRemote) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        CharSequence charSequence = branchName;
        boolean bl2 = bl = charSequence.length() > 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Given branch name cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!isRemote) {
            return branchName;
        }
        List split = StringsKt.split$default((CharSequence)branchName, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
        return split.size() == 1 ? branchName : CollectionsKt.joinToString$default((Iterable)UtilKt.tail((List)split), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    private GitBranchActionsUtil() {
    }

    static {
        GitBranchActionsUtil gitBranchActionsUtil;
        INSTANCE = gitBranchActionsUtil = new GitBranchActionsUtil();
        DataKey dataKey = DataKey.create((String)"Git.Repositories");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DataKey.create<List<GitR\u2026ory>>(\"Git.Repositories\")");
        REPOSITORIES_KEY = dataKey;
        DataKey dataKey2 = DataKey.create((String)"Git.Branches");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"DataKey.create<List<GitBranch>>(\"Git.Branches\")");
        BRANCHES_KEY = dataKey2;
    }
}

