/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.local;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.intellij.indexing.shared.local.SharedIndexLocalFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/indexing/shared/local/PredefinedJsonSharedIndexLocalFinder;", "Lcom/intellij/indexing/shared/local/SharedIndexLocalFinder;", "()V", "findSharedIndexChunks", "", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.indexing.shared"})
public final class PredefinedJsonSharedIndexLocalFinder
implements SharedIndexLocalFinder {
    @Deprecated
    @NotNull
    private static final Logger log;
    @Deprecated
    @Nullable
    private static final String projectRelativeIndexJsonLocation;
    @NotNull
    private static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Path> findSharedIndexChunks(@NotNull Project project) {
        Path jsonFileLocation;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath ?: return emptyList()");
        String basePath = string;
        String string2 = projectRelativeIndexJsonLocation;
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String relativeJsonLocation = string2;
        Path path = Path.of(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Path.of(basePath)");
        Path path2 = path;
        Path path3 = path2.resolve(relativeJsonLocation);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
        path2 = jsonFileLocation = path3;
        Object object = new LinkOption[]{};
        if (Files.notExists(path2, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            JsonNode node = new ObjectMapper().readTree(jsonFileLocation.toFile());
            JsonNode jsonNode = node.get("shared-indexes");
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
            }
            ArrayNode sharedIndexList = (ArrayNode)jsonNode;
            Iterable $this$map$iv = (Iterable)sharedIndexList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path path4 = Path.of(it.asText(), new String[0]);
                collection.add(path4);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            object = jsonFileLocation;
            log.warn("Can't read " + object.toString(), (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PredefinedJsonSharedIndexLocalFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
        projectRelativeIndexJsonLocation = System.getProperty("local.project.shared.index.json.path");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/indexing/shared/local/PredefinedJsonSharedIndexLocalFinder$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "projectRelativeIndexJsonLocation", "", "getProjectRelativeIndexJsonLocation", "()Ljava/lang/String;", "intellij.indexing.shared"})
    private static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        @Nullable
        public final String getProjectRelativeIndexJsonLocation() {
            return projectRelativeIndexJsonLocation;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

