/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributesEffectsBuilder;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TextAttributes.class);
    private static final AttributesFlyweight DEFAULT_FLYWEIGHT = AttributesFlyweight.create(null, null, 0, null, EffectType.BOXED, Collections.emptyMap(), null);
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    @NotNull
    private AttributesFlyweight myAttrs;

    @Contract(value="!null, !null -> !null")
    public static TextAttributes merge(@Nullable TextAttributes under, @Nullable TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        TextAttributesEffectsBuilder.create(under).coverWith(above).applyTo(attrs);
        return attrs;
    }

    public TextAttributes() {
        this(DEFAULT_FLYWEIGHT);
    }

    private TextAttributes(@NotNull AttributesFlyweight attributesFlyweight) {
        if (attributesFlyweight == null) {
            TextAttributes.$$$reportNull$$$0(0);
        }
        this.myAttrs = attributesFlyweight;
    }

    public TextAttributes(@NotNull Element element) {
        if (element == null) {
            TextAttributes.$$$reportNull$$$0(1);
        }
        this.readExternal(element);
    }

    public TextAttributes(@Nullable Color foregroundColor, @Nullable Color backgroundColor, @Nullable Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void copyFrom(@NotNull TextAttributes other) {
        if (other == null) {
            TextAttributes.$$$reportNull$$$0(2);
        }
        this.myAttrs = other.myAttrs;
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, Collections.emptyMap(), errorStripeColor);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    @NotNull
    public AttributesFlyweight getFlyweight() {
        AttributesFlyweight attributesFlyweight = this.myAttrs;
        if (attributesFlyweight == null) {
            TextAttributes.$$$reportNull$$$0(3);
        }
        return attributesFlyweight;
    }

    @NotNull
    public static TextAttributes fromFlyweight(@NotNull AttributesFlyweight flyweight) {
        if (flyweight == null) {
            TextAttributes.$$$reportNull$$$0(4);
        }
        return new TextAttributes(flyweight);
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public void setForegroundColor(Color color) {
        this.myAttrs = this.myAttrs.withForeground(color);
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.myAttrs = this.myAttrs.withBackground(color);
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public void setEffectColor(Color color) {
        this.myAttrs = this.myAttrs.withEffectColor(color);
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public void setErrorStripeColor(Color color) {
        this.myAttrs = this.myAttrs.withErrorStripeColor(color);
    }

    @ApiStatus.Experimental
    public boolean hasEffects() {
        return this.myAttrs.hasEffects();
    }

    @ApiStatus.Experimental
    public void setAdditionalEffects(@NotNull @NotNull Map<@NotNull EffectType, ? extends @NotNull Color> effectsMap) {
        if (effectsMap == null) {
            TextAttributes.$$$reportNull$$$0(5);
        }
        this.myAttrs = this.myAttrs.withAdditionalEffects(effectsMap);
    }

    @ApiStatus.Experimental
    public void withAdditionalEffect(@NotNull EffectType effectType, @NotNull Color color) {
        if (effectType == null) {
            TextAttributes.$$$reportNull$$$0(6);
        }
        if (color == null) {
            TextAttributes.$$$reportNull$$$0(7);
        }
        TextAttributesEffectsBuilder.create(this).coverWith(effectType, color).applyTo(this);
    }

    @Nullable
    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    @ApiStatus.Experimental
    public void forEachAdditionalEffect(@NotNull BiConsumer<? super EffectType, ? super Color> consumer) {
        if (consumer == null) {
            TextAttributes.$$$reportNull$$$0(8);
        }
        this.myAttrs.getAdditionalEffects().forEach(consumer);
    }

    @ApiStatus.Experimental
    public void forEachEffect(@NotNull BiConsumer<? super EffectType, ? super Color> consumer) {
        if (consumer == null) {
            TextAttributes.$$$reportNull$$$0(9);
        }
        this.myAttrs.getAllEffects().forEach(consumer);
    }

    public void setEffectType(EffectType effectType) {
        this.myAttrs = this.myAttrs.withEffectType(effectType);
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public void setFontType(@JdkConstants.FontStyle int type) {
        if (type < 0 || type > 3) {
            LOG.error("Wrong font type: " + type);
            type = 0;
        }
        this.myAttrs = this.myAttrs.withFontType(type);
    }

    public TextAttributes clone() {
        return new TextAttributes(this.myAttrs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return Objects.equals(this.myAttrs, ((TextAttributes)obj).myAttrs);
    }

    public int hashCode() {
        return this.myAttrs.hashCode();
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            TextAttributes.$$$reportNull$$$0(10);
        }
        this.myAttrs = AttributesFlyweight.create(element);
    }

    public void writeExternal(Element element) {
        this.myAttrs.writeExternal(element);
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.myAttrs.getAdditionalEffects() + "," + this.getErrorStripeColor() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesFlyweight";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flyweight";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectsMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlyweight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromFlyweight";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalEffects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalEffect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forEachAdditionalEffect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachEffect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

