/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u001a*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001aB#\b\u0005\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J>\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\b\u0018\u00010\u0013j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/testing/AbstractPythonTestRunConfiguration;", "T", "Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "requiredPackage", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "getRequiredPackage", "()Ljava/lang/String;", "checkConfiguration", "", "getTestSpec", "location", "Lcom/intellij/execution/Location;", "failedTest", "Lcom/intellij/execution/testframework/AbstractTestProxy;", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "isFrameworkInstalled", "", "Companion", "intellij.python.community.impl"})
public abstract class AbstractPythonTestRunConfiguration<T extends AbstractPythonTestRunConfiguration<T>>
extends AbstractPythonRunConfiguration<T> {
    @Nullable
    private final String requiredPackage;
    @NotNull
    protected static final String TEST_NAME_PARTS_SPLITTER = "::";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        Intrinsics.checkNotNullParameter(location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)failedTest, (String)"failedTest");
        PsiElement element = location.getPsiElement();
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (location instanceof PyPsiLocationWithFixedClass) {
            pyClass = ((PyPsiLocationWithFixedClass)location).getFixedClass();
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        VirtualFile virtualFile = location.getVirtualFile();
        if (virtualFile != null) {
            Object path2 = virtualFile.getCanonicalPath();
            if (pyClass != null) {
                path2 = (String)path2 + (TEST_NAME_PARTS_SPLITTER + pyClass.getName());
            }
            if (pyFunction != null) {
                path2 = (String)path2 + (TEST_NAME_PARTS_SPLITTER + pyFunction.getName());
            }
            return path2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<TargetEnvironment, String> getTestSpec(@NotNull TargetEnvironmentRequest request, @NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        Function function;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)failedTest, (String)"failedTest");
        PsiElement element = location.getPsiElement();
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (location instanceof PyPsiLocationWithFixedClass) {
            pyClass = ((PyPsiLocationWithFixedClass)location).getFixedClass();
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        VirtualFile virtualFile = location.getVirtualFile();
        Object object = virtualFile;
        if (object != null && (object = object.getCanonicalPath()) != null) {
            Collection<Function> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object2;
            Object localPath = object2 = object;
            boolean bl = false;
            Object object3 = localPath;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"localPath");
            Function targetPath = TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((TargetEnvironmentRequest)request, (String)object3);
            Object[] objectArray = new String[2];
            PyClass pyClass2 = pyClass;
            objectArray[0] = pyClass2 != null ? pyClass2.getName() : null;
            PyFunction pyFunction2 = pyFunction;
            objectArray[1] = pyFunction2 != null ? pyFunction2.getName() : null;
            Iterable iterable = CollectionsKt.listOfNotNull((Object[])objectArray);
            Collection collection2 = CollectionsKt.listOf((Object)targetPath);
            boolean $i$f$map = false;
            void var15_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Function function2 = TargetEnvironmentFunctions.constant((Object)p1);
                collection.add(function2);
            }
            collection = (List)destination$iv$iv;
            function = TargetEnvironmentFunctions.joinToStringFunction$default((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (CharSequence)TEST_NAME_PARTS_SPLITTER, null, (int)2, null);
        } else {
            function = null;
        }
        return function;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (this.requiredPackage != null && !this.isFrameworkInstalled()) {
            throw (Throwable)new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", this.requiredPackage));
        }
    }

    public final boolean isFrameworkInstalled() {
        PyPackage pyPackage;
        Sdk sdk = this.getSdk();
        if (sdk == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"sdk ?: return false");
        Sdk sdk2 = sdk;
        String string = this.requiredPackage;
        if (string == null) {
            return true;
        }
        String requiredPackage = string;
        PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)pyPackageManager, (String)"PyPackageManager.getInstance(sdk)");
        List<PyPackage> list = pyPackageManager.getPackages();
        if (list != null) {
            Object v5;
            block5: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PyPackage it = (PyPackage)((Object)element$iv);
                    boolean bl = false;
                    PyPackage pyPackage2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)pyPackage2), (String)"it");
                    if (!Intrinsics.areEqual((Object)pyPackage2.getName(), (Object)requiredPackage)) continue;
                    v5 = element$iv;
                    break block5;
                }
                v5 = null;
            }
            pyPackage = v5;
        } else {
            pyPackage = null;
        }
        return pyPackage != null;
    }

    @Nullable
    public final String getRequiredPackage() {
        return this.requiredPackage;
    }

    @JvmOverloads
    protected AbstractPythonTestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @Nullable String requiredPackage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(project, factory);
        this.requiredPackage = requiredPackage;
    }

    public /* synthetic */ AbstractPythonTestRunConfiguration(Project project, ConfigurationFactory configurationFactory, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(project, configurationFactory, string);
    }

    @JvmOverloads
    protected AbstractPythonTestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        this(project, factory, null, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/testing/AbstractPythonTestRunConfiguration$Companion;", "", "()V", "TEST_NAME_PARTS_SPLITTER", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

