/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jf\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0007J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyProjectVirtualEnvConfiguration;", "", "()V", "createVirtualEnvSynchronously", "Lcom/intellij/openapi/projectRoots/Sdk;", "baseSdk", "existingSdks", "", "venvRoot", "", "projectBasePath", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "inheritSitePackages", "", "makeShared", "findPreferredVirtualEnvBaseSdk", "existingBaseSdks", "intellij.python.community.impl"})
public final class PyProjectVirtualEnvConfiguration {
    @NotNull
    public static final PyProjectVirtualEnvConfiguration INSTANCE;

    @RequiresEdt
    @Nullable
    public final Sdk createVirtualEnvSynchronously(@Nullable Sdk baseSdk, @NotNull List<? extends Sdk> existingSdks2, @NotNull String venvRoot, @Nullable String projectBasePath, @Nullable Project project, @Nullable Module module, @NotNull UserDataHolder context2, boolean inheritSitePackages, boolean makeShared) {
        String string;
        Intrinsics.checkNotNullParameter(existingSdks2, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)venvRoot, (String)"venvRoot");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Sdk installedSdk = PySdkToInstallKt.installSdkIfNeeded(baseSdk, module, existingSdks2, context2);
        if (installedSdk == null) {
            return null;
        }
        String string2 = projectBasePath;
        if (string2 == null) {
            Module module2 = module;
            string2 = string = module2 != null ? BasePySdkExtKt.getBasePath(module2) : null;
        }
        if (string2 == null) {
            Project project2 = project;
            string = project2 != null ? project2.getBasePath() : null;
        }
        String projectPath = string;
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(installedSdk, venvRoot, inheritSitePackages, project, project, PySdkBundle.message("python.creating.venv.title", new Object[0]), false){
            final /* synthetic */ Sdk $installedSdk;
            final /* synthetic */ String $venvRoot;
            final /* synthetic */ boolean $inheritSitePackages;
            final /* synthetic */ Project $project;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Sdk sdk;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (this.$installedSdk instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)this.$installedSdk))) {
                    Sdk sdk2 = ProjectJdkTable.getInstance().findJdk(this.$installedSdk.getName());
                    sdk = sdk2;
                    Intrinsics.checkNotNull((Object)sdk2);
                } else {
                    sdk = this.$installedSdk;
                }
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"if (installedSdk is Disp\u2026   installedSdk\n        }");
                Sdk sdk3 = sdk;
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk3);
                Intrinsics.checkNotNullExpressionValue((Object)pyPackageManager, (String)"PyPackageManager.getInstance(sdk)");
                PyPackageManager packageManager = pyPackageManager;
                String string = packageManager.createVirtualEnv(this.$venvRoot, this.$inheritSitePackages);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageManager.createVir\u2026oot, inheritSitePackages)");
                return string;
            }
            {
                this.$installedSdk = $captured_local_variable$0;
                this.$venvRoot = $captured_local_variable$1;
                this.$inheritSitePackages = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
        String associatedPath = !makeShared ? projectPath : null;
        Sdk sdk = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), existingSdks2, installedSdk, associatedPath, null);
        if (sdk == null) {
            return null;
        }
        Sdk venvSdk = sdk;
        if (!makeShared) {
            PySdkExtKt.associateWithModule(venvSdk, module, projectBasePath);
        }
        PySdkExtKt.excludeInnerVirtualEnv(project, venvSdk);
        PySdkSettings pySdkSettings = PySdkSettings.Companion.getInstance();
        String string3 = FileUtil.toSystemIndependentName((String)venvRoot);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FileUtil.toSystemIndependentName(venvRoot)");
        pySdkSettings.onVirtualEnvCreated(installedSdk, string3, projectPath);
        return venvSdk;
    }

    public static /* synthetic */ Sdk createVirtualEnvSynchronously$default(PyProjectVirtualEnvConfiguration pyProjectVirtualEnvConfiguration, Sdk sdk, List list, String string, String string2, Project project, Module module, UserDataHolder userDataHolder, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            userDataHolder = (UserDataHolder)new UserDataHolderBase();
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        return pyProjectVirtualEnvConfiguration.createVirtualEnvSynchronously(sdk, list, string, string2, project, module, userDataHolder, bl, bl2);
    }

    @Nullable
    public final Sdk findPreferredVirtualEnvBaseSdk(@NotNull List<? extends Sdk> existingBaseSdks) {
        Object v0;
        String preferredSdkPath;
        block1: {
            Iterable iterable;
            String string;
            Intrinsics.checkNotNullParameter(existingBaseSdks, (String)"existingBaseSdks");
            String p1 = string = PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBaseSdk();
            boolean bl = false;
            preferredSdkPath = FileUtil.exists((String)p1) ? string : null;
            Iterable iterable2 = iterable = (Iterable)existingBaseSdks;
            for (Object t : iterable2) {
                Sdk it = (Sdk)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getHomePath(), (Object)preferredSdkPath)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Sdk detectedPreferredSdk = v0;
        return detectedPreferredSdk != null ? detectedPreferredSdk : (preferredSdkPath != null ? (Sdk)new PyDetectedSdk(preferredSdkPath) : (Sdk)CollectionsKt.getOrNull(existingBaseSdks, (int)0));
    }

    private PyProjectVirtualEnvConfiguration() {
    }

    static {
        PyProjectVirtualEnvConfiguration pyProjectVirtualEnvConfiguration;
        INSTANCE = pyProjectVirtualEnvConfiguration = new PyProjectVirtualEnvConfiguration();
    }
}

