/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.sdk.AddInterpreterActions;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/sdk/AddInterpreterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "currentSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)V", "getCurrentSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
public final class AddInterpreterAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final Module module;
    @Nullable
    private final Sdk currentSdk;

    public void actionPerformed(@NotNull AnActionEvent e) {
        ProjectSdksModel model;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PyConfigurableInterpreterList pyConfigurableInterpreterList = PyConfigurableInterpreterList.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)pyConfigurableInterpreterList, (String)"PyConfigurableInterpreterList.getInstance(project)");
        ProjectSdksModel projectSdksModel = model = pyConfigurableInterpreterList.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)projectSdksModel, (String)"model");
        Object[] objectArray = projectSdksModel.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"model.sdks");
        PyAddSdkDialog.Companion.show(this.project, this.module, ArraysKt.asList((Object[])objectArray), new Consumer(this, model){
            final /* synthetic */ AddInterpreterAction this$0;
            final /* synthetic */ ProjectSdksModel $model;

            public final void accept(@Nullable Sdk it) {
                if (it != null && this.$model.findSdk(it.getName()) == null) {
                    this.$model.addSdk(it);
                    this.$model.apply();
                    AddInterpreterActions.switchToSdk(this.this$0.getModule(), it, this.this$0.getCurrentSdk());
                }
            }
            {
                this.this$0 = addInterpreterAction;
                this.$model = projectSdksModel;
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Nullable
    public final Sdk getCurrentSdk() {
        return this.currentSdk;
    }

    public AddInterpreterAction(@NotNull Project project, @NotNull Module module, @Nullable Sdk currentSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(PyBundle.messagePointer("python.sdk.popup.add.interpreter", new Object[0]));
        this.project = project;
        this.module = module;
        this.currentSdk = currentSdk;
    }
}

