/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.lexer.PythonLexerKind;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class PythonHighlightingLexer
extends PythonLexer {
    private final LanguageLevel myLanguageLevel;
    private state myState;
    private boolean hasUnicodeImport;
    private int myImportOffset;
    private boolean hasPrintFunctionImport;

    public PythonHighlightingLexer(LanguageLevel languageLevel) {
        this(languageLevel, PythonLexerKind.REGULAR);
    }

    public PythonHighlightingLexer(LanguageLevel languageLevel, @NotNull PythonLexerKind kind) {
        if (kind == null) {
            PythonHighlightingLexer.$$$reportNull$$$0(0);
        }
        super(kind);
        this.myState = state.init;
        this.myImportOffset = -1;
        this.myLanguageLevel = languageLevel;
        this.hasUnicodeImport = false;
        this.hasPrintFunctionImport = false;
    }

    @NotNull
    public static IElementType convertStringType(@NotNull IElementType tokenType, @NotNull String tokenText, @NotNull LanguageLevel languageLevel, boolean unicodeImport) {
        if (tokenType == null) {
            PythonHighlightingLexer.$$$reportNull$$$0(1);
        }
        if (tokenText == null) {
            PythonHighlightingLexer.$$$reportNull$$$0(2);
        }
        if (languageLevel == null) {
            PythonHighlightingLexer.$$$reportNull$$$0(3);
        }
        String prefix = PyStringLiteralUtil.getPrefix(tokenText);
        if (tokenType == PyTokenTypes.SINGLE_QUOTED_STRING) {
            if (languageLevel.isPy3K()) {
                if (!PyStringLiteralUtil.isBytesPrefix(prefix)) {
                    PyElementType pyElementType = PyTokenTypes.SINGLE_QUOTED_UNICODE;
                    if (pyElementType == null) {
                        PythonHighlightingLexer.$$$reportNull$$$0(4);
                    }
                    return pyElementType;
                }
            } else if (unicodeImport && !PyStringLiteralUtil.isBytesPrefix(prefix) || PyStringLiteralUtil.isUnicodePrefix(prefix)) {
                PyElementType pyElementType = PyTokenTypes.SINGLE_QUOTED_UNICODE;
                if (pyElementType == null) {
                    PythonHighlightingLexer.$$$reportNull$$$0(5);
                }
                return pyElementType;
            }
        }
        if (tokenType == PyTokenTypes.TRIPLE_QUOTED_STRING) {
            if (languageLevel.isPy3K()) {
                if (!PyStringLiteralUtil.isBytesPrefix(prefix)) {
                    PyElementType pyElementType = PyTokenTypes.TRIPLE_QUOTED_UNICODE;
                    if (pyElementType == null) {
                        PythonHighlightingLexer.$$$reportNull$$$0(6);
                    }
                    return pyElementType;
                }
            } else if (unicodeImport && !PyStringLiteralUtil.isBytesPrefix(prefix) || PyStringLiteralUtil.isUnicodePrefix(prefix)) {
                PyElementType pyElementType = PyTokenTypes.TRIPLE_QUOTED_UNICODE;
                if (pyElementType == null) {
                    PythonHighlightingLexer.$$$reportNull$$$0(7);
                }
                return pyElementType;
            }
        }
        IElementType iElementType = tokenType;
        if (iElementType == null) {
            PythonHighlightingLexer.$$$reportNull$$$0(8);
        }
        return iElementType;
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if (PyTokenTypes.STRING_NODES.contains(tokenType)) {
            return PythonHighlightingLexer.convertStringType(tokenType, this.getTokenText(), this.myLanguageLevel, this.hasUnicodeImport);
        }
        if (tokenType == PyTokenTypes.IDENTIFIER) {
            String tokenText = this.getTokenText();
            if (tokenText.equals("with")) {
                return PyTokenTypes.WITH_KEYWORD;
            }
            if (tokenText.equals("as")) {
                return PyTokenTypes.AS_KEYWORD;
            }
            if (this.myLanguageLevel.hasPrintStatement() && !this.hasPrintFunctionImport && tokenText.equals("print")) {
                return PyTokenTypes.PRINT_KEYWORD;
            }
            if (this.myLanguageLevel.isPy3K()) {
                if (tokenText.equals("None")) {
                    return PyTokenTypes.NONE_KEYWORD;
                }
                if (tokenText.equals("True")) {
                    return PyTokenTypes.TRUE_KEYWORD;
                }
                if (tokenText.equals("False")) {
                    return PyTokenTypes.FALSE_KEYWORD;
                }
                if (tokenText.equals("nonlocal")) {
                    return PyTokenTypes.NONLOCAL_KEYWORD;
                }
                if (tokenText.equals("__debug__")) {
                    return PyTokenTypes.DEBUG_KEYWORD;
                }
                if (this.myLanguageLevel.isAtLeast(LanguageLevel.PYTHON37)) {
                    if (tokenText.equals("async")) {
                        return PyTokenTypes.ASYNC_KEYWORD;
                    }
                    if (tokenText.equals("await")) {
                        return PyTokenTypes.AWAIT_KEYWORD;
                    }
                }
            } else if (tokenText.equals("exec")) {
                return PyTokenTypes.EXEC_KEYWORD;
            }
        }
        return tokenType;
    }

    public void advance() {
        IElementType type = super.getTokenType();
        switch (this.myState) {
            case init: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type) || PyTokenTypes.END_OF_LINE_COMMENT == type || PyTokenTypes.DOCSTRING == type) break;
                if (type == PyTokenTypes.FROM_KEYWORD) {
                    this.myState = state.pending_future;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_future: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IDENTIFIER && "__future__".equals(super.getTokenText())) {
                    this.myState = state.pending_import;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_import: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IMPORT_KEYWORD) {
                    this.myState = state.pending_lpar;
                    break;
                }
                this.myState = state.stop;
                break;
            }
            case pending_lpar: {
                if (type == PyTokenTypes.LPAR) {
                    this.myState = state.pending_id;
                    break;
                }
            }
            case pending_id: {
                if (type == PyTokenTypes.BACKSLASH || PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type)) break;
                if (type == PyTokenTypes.IDENTIFIER) {
                    this.myState = state.pending_comma;
                    if ("unicode_literals".equals(super.getTokenText())) {
                        this.hasUnicodeImport = true;
                        this.myImportOffset = this.getTokenEnd();
                        break;
                    }
                    if (!FutureFeature.PRINT_FUNCTION.toString().equals(super.getTokenText())) break;
                    this.hasPrintFunctionImport = true;
                    this.myImportOffset = this.getTokenEnd();
                    break;
                }
                this.myState = state.init;
                break;
            }
            case pending_comma: {
                if (type == PyTokenTypes.RPAR || type == PyTokenTypes.BACKSLASH) break;
                if (PyTokenTypes.LINE_BREAK == type) {
                    this.myState = state.init;
                }
                if (PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(type) || type != PyTokenTypes.COMMA) break;
                this.myState = state.pending_id;
                break;
            }
        }
        super.advance();
    }

    public int getImportOffset() {
        return this.myImportOffset;
    }

    public void clearState(int position) {
        this.myState = state.init;
        this.myImportOffset = position;
        this.hasUnicodeImport = false;
        this.hasPrintFunctionImport = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PythonHighlightingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PythonHighlightingLexer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStringType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertStringType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum state {
        init,
        pending_future,
        pending_import,
        pending_lpar,
        pending_id,
        pending_comma,
        stop;

    }
}

