/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.facet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class PythonSdkComboBox
extends ComboboxWithBrowseButton {
    private Project myProject;

    public PythonSdkComboBox() {
        this.getComboBox().setRenderer(new PySdkListCellRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project;
                Sdk selectedSdk = PythonSdkComboBox.this.getSelectedSdk();
                ProjectJdksEditor editor2 = new ProjectJdksEditor(selectedSdk, project = PythonSdkComboBox.this.myProject != null ? PythonSdkComboBox.this.myProject : ProjectManager.getInstance().getDefaultProject(), (Component)((Object)PythonSdkComboBox.this));
                if (editor2.showAndGet()) {
                    selectedSdk = editor2.getSelectedJdk();
                    PythonSdkComboBox.this.updateSdkList(selectedSdk, false);
                }
            }
        });
        this.updateSdkList(null, true);
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void updateSdkList(Sdk sdkToSelect, boolean selectAnySdk) {
        List sdkList = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)PythonSdkType.getInstance());
        if (selectAnySdk && sdkList.size() > 0) {
            sdkToSelect = (Sdk)sdkList.get(0);
        }
        sdkList.add(0, null);
        this.getComboBox().setModel(new DefaultComboBoxModel<Sdk>(sdkList.toArray(new Sdk[0])));
        this.getComboBox().setSelectedItem(sdkToSelect);
    }

    public void updateSdkList() {
        this.updateSdkList((Sdk)this.getComboBox().getSelectedItem(), false);
    }

    public Sdk getSelectedSdk() {
        return (Sdk)this.getComboBox().getSelectedItem();
    }
}

