/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.doctest;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.doctest.PyDocstringLanguageDialect;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyDocstringLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            PyDocstringLanguageInjector.$$$reportNull$$$0(0);
        }
        if (injectionPlacesRegistrar == null) {
            PyDocstringLanguageInjector.$$$reportNull$$$0(1);
        }
        if (!(host instanceof PyStringLiteralExpression)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)host);
        if (module == null || !PyDocumentationSettings.getInstance(module).isAnalyzeDoctest()) {
            return;
        }
        if (DocStringUtil.getParentDefinitionDocString((PsiElement)host) == host) {
            int start = 0;
            int end = host.getTextLength() - 1;
            String text2 = host.getText();
            Pair<String, String> quotes = PyStringLiteralUtil.getQuotes(text2);
            List strings = StringUtil.split((String)text2, (String)"\n", (boolean)false);
            boolean gotExample = false;
            int currentPosition = 0;
            int maxPosition = text2.length();
            boolean endsWithSlash = false;
            for (String string : strings) {
                String closingQuote;
                String trimmedString = string.trim();
                if (!trimmedString.startsWith(">>>") && !trimmedString.startsWith("...") && gotExample && start < end) {
                    gotExample = false;
                    if (!endsWithSlash) {
                        injectionPlacesRegistrar.addPlace((Language)PyDocstringLanguageDialect.getInstance(), TextRange.create((int)start, (int)end), null, null);
                    }
                }
                String string2 = closingQuote = quotes == null ? text2.substring(0, 1) : (String)quotes.second;
                if (endsWithSlash && !trimmedString.endsWith("\\")) {
                    endsWithSlash = false;
                    injectionPlacesRegistrar.addPlace((Language)PyDocstringLanguageDialect.getInstance(), TextRange.create((int)start, (int)PyDocstringLanguageInjector.getEndOffset(currentPosition, string, maxPosition, closingQuote)), null, null);
                }
                if (trimmedString.startsWith(">>>")) {
                    if (trimmedString.endsWith("\\")) {
                        endsWithSlash = true;
                    }
                    if (!gotExample) {
                        start = currentPosition;
                    }
                    gotExample = true;
                    end = PyDocstringLanguageInjector.getEndOffset(currentPosition, string, maxPosition, closingQuote);
                } else if (trimmedString.startsWith("...") && gotExample) {
                    if (trimmedString.endsWith("\\")) {
                        endsWithSlash = true;
                    }
                    end = PyDocstringLanguageInjector.getEndOffset(currentPosition, string, maxPosition, closingQuote);
                }
                currentPosition += string.length();
            }
            if (gotExample && start < end) {
                injectionPlacesRegistrar.addPlace((Language)PyDocstringLanguageDialect.getInstance(), TextRange.create((int)start, (int)end), null, null);
            }
        }
    }

    private static int getEndOffset(int start, String s, int maxPosition, String closingQuote) {
        int length = s.length();
        if (s.trim().endsWith(closingQuote)) {
            length -= 3;
        } else if (start + length == maxPosition && (s.trim().endsWith("\"") || s.trim().endsWith("'"))) {
            --length;
        }
        int end = start + length;
        if (s.endsWith("\n")) {
            --end;
        }
        return end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "injectionPlacesRegistrar";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/documentation/doctest/PyDocstringLanguageInjector";
        objectArray[2] = "getLanguagesToInject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

