/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class PyDocumentationSettingsDetector
implements Function<Pair<Module, Collection<VirtualFile>>, PyDocumentationSettings.ServiceState> {
    private static final Logger LOG = Logger.getInstance(PyDocumentationSettingsDetector.class);

    PyDocumentationSettingsDetector() {
    }

    public PyDocumentationSettings.ServiceState fun(@NotNull Pair<Module, Collection<VirtualFile>> pair) {
        Module module;
        if (pair == null) {
            PyDocumentationSettingsDetector.$$$reportNull$$$0(0);
        }
        if ((module = (Module)pair.first).isDisposed()) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        assert (!application.isDispatchThread()) : "This method should not be called on AWT";
        for (VirtualFile file : (Collection)pair.second) {
            DocStringFormat docFormat = (DocStringFormat)((Object)ReadAction.compute(() -> PyDocumentationSettingsDetector.checkDocString(file, module)));
            if (docFormat == PyDocumentationSettings.DEFAULT_DOC_STRING_FORMAT) continue;
            LOG.debug("Docstring format '" + docFormat + "' was detected from content of the file '" + file.getPath() + "'");
            return new PyDocumentationSettings.ServiceState(docFormat);
        }
        return null;
    }

    @NotNull
    private static DocStringFormat checkDocString(@NotNull VirtualFile file, @NotNull Module module) {
        PsiFile psiFile;
        if (file == null) {
            PyDocumentationSettingsDetector.$$$reportNull$$$0(1);
        }
        if (module == null) {
            PyDocumentationSettingsDetector.$$$reportNull$$$0(2);
        }
        if ((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) instanceof PyFile) {
            DocStringFormat perFileFormat = PyDocumentationSettings.getFormatFromDocformatAttribute(psiFile);
            if (perFileFormat != null) {
                DocStringFormat docStringFormat = perFileFormat;
                if (docStringFormat == null) {
                    PyDocumentationSettingsDetector.$$$reportNull$$$0(3);
                }
                return docStringFormat;
            }
            PyDocStringOwner[] children2 = (PyDocStringOwner[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, PyDocStringOwner.class);
            if (children2 != null) {
                for (PyDocStringOwner owner : children2) {
                    DocStringFormat guessed;
                    PyStringLiteralExpression docStringExpression = owner.getDocStringExpression();
                    if (docStringExpression == null || (guessed = DocStringUtil.guessDocStringFormat(docStringExpression.getStringValue())) == PyDocumentationSettings.DEFAULT_DOC_STRING_FORMAT) continue;
                    DocStringFormat docStringFormat = guessed;
                    if (docStringFormat == null) {
                        PyDocumentationSettingsDetector.$$$reportNull$$$0(4);
                    }
                    return docStringFormat;
                }
            }
        }
        DocStringFormat docStringFormat = PyDocumentationSettings.DEFAULT_DOC_STRING_FORMAT;
        if (docStringFormat == null) {
            PyDocumentationSettingsDetector.$$$reportNull$$$0(5);
        }
        return docStringFormat;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationSettingsDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationSettingsDetector";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDocString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkDocString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

