/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.command;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.commandInterface.command.ArgumentsInfo;
import com.jetbrains.commandInterface.command.Command;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.command.Help;
import com.jetbrains.commandInterface.command.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleCommand
implements Command {
    @NotNull
    @NlsSafe
    private final String myName;
    @Nullable
    private final Help myHelp;
    @NotNull
    private final ArgumentsInfo myArgumentsInfo;
    @NotNull
    private final List<Option> myOptions;
    @NotNull
    private final CommandExecutor myExecutor;

    public SimpleCommand(@NotNull @NlsSafe String name2, @Nullable Help help, @NotNull ArgumentsInfo argumentsInfo, @NotNull CommandExecutor executor, @NotNull Collection<Option> options) {
        if (name2 == null) {
            SimpleCommand.$$$reportNull$$$0(0);
        }
        if (argumentsInfo == null) {
            SimpleCommand.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            SimpleCommand.$$$reportNull$$$0(2);
        }
        if (options == null) {
            SimpleCommand.$$$reportNull$$$0(3);
        }
        this.myOptions = new ArrayList<Option>();
        this.myName = name2;
        this.myHelp = help;
        this.myArgumentsInfo = argumentsInfo;
        this.myExecutor = executor;
        this.myOptions.addAll(options);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SimpleCommand.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Help getHelp(boolean tryCutOutArguments) {
        if (!tryCutOutArguments || this.myHelp == null) {
            return this.myHelp;
        }
        @NlsSafe String newHelpString = this.myHelp.getHelpString().replaceAll("(\\[[^\\]]+\\]|<[^>]+>|\\.{3,}|^" + this.myName + ")", "").trim();
        return new Help(newHelpString, this.myHelp.getExternalHelpUrl());
    }

    @Override
    @NotNull
    public ArgumentsInfo getArgumentsInfo() {
        ArgumentsInfo argumentsInfo = this.myArgumentsInfo;
        if (argumentsInfo == null) {
            SimpleCommand.$$$reportNull$$$0(5);
        }
        return argumentsInfo;
    }

    @Override
    @NotNull
    public List<Option> getOptions() {
        List<Option> list = Collections.unmodifiableList(this.myOptions);
        if (list == null) {
            SimpleCommand.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void execute(@NotNull String commandName, @NotNull Module module, @NotNull List<String> parameters, @Nullable ConsoleView consoleView) {
        if (commandName == null) {
            SimpleCommand.$$$reportNull$$$0(7);
        }
        if (module == null) {
            SimpleCommand.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            SimpleCommand.$$$reportNull$$$0(9);
        }
        this.myExecutor.execute(this.myName, module, parameters, consoleView);
    }

    @NotNull
    public CommandExecutor getExecutor() {
        CommandExecutor commandExecutor = this.myExecutor;
        if (commandExecutor == null) {
            SimpleCommand.$$$reportNull$$$0(10);
        }
        return commandExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/command/SimpleCommand";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/command/SimpleCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

