/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.storage;

import java.nio.channels.ReadableByteChannel;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import libraries.io.channels.ChannelUtilsKt;
import libraries.io.storage.Blob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Llibraries/io/storage/ByteArrayBlob;", "Llibraries/io/storage/Blob;", "path", "", "data", "", "contentType", "(Ljava/lang/String;[BLjava/lang/String;)V", "getContentType", "()Ljava/lang/String;", "created", "", "getCreated", "()J", "length", "getLength", "name", "getName", "getPath", "getContent", "Ljava/nio/channels/ReadableByteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "libraries-io"})
public final class ByteArrayBlob
implements Blob {
    @NotNull
    private final String path;
    @NotNull
    private final byte[] data;
    @NotNull
    private final String contentType;

    public ByteArrayBlob(@NotNull String path2, @NotNull byte[] data2, @NotNull String contentType2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)contentType2, (String)"contentType");
        this.path = path2;
        this.data = data2;
        this.contentType = contentType2;
    }

    public /* synthetic */ ByteArrayBlob(String string2, byte[] byArray, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "application/octet-stream";
        }
        this(string2, byArray, string3);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public String getName() {
        return StringsKt.substringAfterLast$default((String)this.getPath(), (char)'/', null, (int)2, null);
    }

    @Override
    public long getCreated() {
        return Instant.now().getEpochSecond();
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    @Nullable
    public Object getContent(@NotNull Continuation<? super ReadableByteChannel> $completion) {
        return ChannelUtilsKt.toChannel(this.data);
    }
}

