/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

@Deprecated
public class DateMidnightDeserializer
extends JodaDateDeserializerBase<DateMidnight> {
    private static final long serialVersionUID = 1L;

    public DateMidnightDeserializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT);
    }

    public DateMidnightDeserializer(JacksonJodaDateFormat format2) {
        super(DateMidnight.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new DateMidnightDeserializer(format2);
    }

    public DateMidnight deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.isExpectedStartArrayToken()) {
            p2.nextToken();
            int year = p2.getIntValue();
            p2.nextToken();
            int month = p2.getIntValue();
            p2.nextToken();
            int day = p2.getIntValue();
            if (p2.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.END_ARRAY, "after DateMidnight ints");
            }
            DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
            return new DateMidnight(year, month, day, tz);
        }
        switch (p2.currentTokenId()) {
            case 7: {
                return new DateMidnight(p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
        }
        throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.START_ARRAY, "expected JSON Array, Number or String");
    }

    protected DateMidnight _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (DateMidnight)this._fromEmptyString(p2, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value2));
        }
        LocalDate local = this._format.createParser(ctxt).parseLocalDate(value2);
        if (local == null) {
            return null;
        }
        return local.toDateMidnight();
    }

    protected DateMidnight _fromTimestamp(DeserializationContext ctxt, long ts) {
        return new DateMidnight(ts);
    }
}

