/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemEventSerializer {
    @NotNull
    public static String serialize(@NotNull ExternalSystemEvent event) {
        if (event == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(0);
        }
        String prefix = event.getTimestamp() + " " + event.getEventType().name() + " " + event.getRecorderId();
        if (event instanceof ExternalUploadFinishedEvent) {
            ExternalUploadFinishedEvent failed = (ExternalUploadFinishedEvent)event;
            if (StatisticsStringUtil.isNotEmpty(failed.getError())) {
                String string = prefix + " " + StatisticsEventEscaper.escape((String)failed.getError());
                if (string == null) {
                    ExternalSystemEventSerializer.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = prefix;
            if (string == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (event instanceof ExternalUploadSendEvent) {
            ExternalUploadSendEvent finished = (ExternalUploadSendEvent)event;
            String hashedFiles = ExternalSystemEventSerializer.filesToString(finished.getSuccessfullySentFiles());
            String errors = ExternalSystemEventSerializer.errorsToString(finished.getErrors());
            String string = prefix + " " + finished.getSucceed() + " " + finished.getFailed() + " " + finished.getTotal() + " " + hashedFiles + " " + errors;
            if (string == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (event instanceof ExternalSystemErrorEvent) {
            ExternalSystemErrorEvent error = (ExternalSystemErrorEvent)event;
            String string = prefix + " " + StatisticsEventEscaper.escape((String)error.getEvent()) + " " + StatisticsEventEscaper.escape((String)error.getErrorClass());
            if (string == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = prefix;
        if (string == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static ExternalSystemEvent deserialize(@NotNull String line, int version) {
        String recorderId;
        if (line == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(6);
        }
        int payloadStartIndex = version == 0 ? 2 : 3;
        String[] parts = line.split(" ");
        int length = parts.length;
        if (length < payloadStartIndex) {
            return null;
        }
        ExternalSystemEventType type = ExternalSystemEventType.parse(parts[1]);
        if (type == null) {
            return null;
        }
        long timestamp = ExternalSystemEventSerializer.parseLong(parts[0]);
        String string = recorderId = version == 0 ? "FUS" : parts[2];
        if (type == ExternalSystemEventType.FINISHED) {
            String error = length > payloadStartIndex ? parts[payloadStartIndex].trim() : null;
            return new ExternalUploadFinishedEvent(timestamp, error, recorderId);
        }
        if (type == ExternalSystemEventType.SEND && length > payloadStartIndex + 2) {
            int succeed = ExternalSystemEventSerializer.parseInt(parts[payloadStartIndex]);
            int failed = ExternalSystemEventSerializer.parseInt(parts[payloadStartIndex + 1]);
            int total = ExternalSystemEventSerializer.parseInt(parts[payloadStartIndex + 2]);
            List<String> sentFiles = length > payloadStartIndex + 3 ? ExternalSystemEventSerializer.parseSentFiles(parts[payloadStartIndex + 3]) : Collections.emptyList();
            List<Integer> errors = length > payloadStartIndex + 4 ? ExternalSystemEventSerializer.parseErrors(parts[payloadStartIndex + 4]) : Collections.emptyList();
            return new ExternalUploadSendEvent(timestamp, succeed, failed, total, sentFiles, errors, recorderId);
        }
        if (type == ExternalSystemEventType.STARTED && length == payloadStartIndex) {
            return new ExternalUploadStartedEvent(timestamp, recorderId);
        }
        if (type == ExternalSystemEventType.ERROR && length == payloadStartIndex + 2) {
            String event = parts[payloadStartIndex].trim();
            String errorClass = parts[payloadStartIndex + 1].trim();
            return new ExternalSystemErrorEvent(timestamp, event, errorClass, recorderId);
        }
        return null;
    }

    @NotNull
    private static List<String> parseSentFiles(@NotNull String part) {
        if (part == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(7);
        }
        return ExternalSystemEventSerializer.parseValues(part, value -> new String(Base64.getDecoder().decode((String)value), StandardCharsets.UTF_8));
    }

    @NotNull
    private static List<Integer> parseErrors(@NotNull String part) {
        if (part == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(8);
        }
        return ExternalSystemEventSerializer.parseValues(part, value -> ExternalSystemEventSerializer.parseInt(value));
    }

    @NotNull
    private static <V> List<V> parseValues(@NotNull String part, @NotNull Function<? super String, ? extends V> processor) {
        block8: {
            List list;
            if (part == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(9);
            }
            if (processor == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(10);
            }
            try {
                if (!part.startsWith("[") || !part.endsWith("]")) break block8;
                String unwrappedPart = part.substring(1, part.length() - 1);
                String[] values = unwrappedPart.split(",");
                list = Arrays.stream(values).filter(value -> !value.isEmpty()).map(processor).collect(Collectors.toList());
            }
            catch (IllegalArgumentException e) {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    ExternalSystemEventSerializer.$$$reportNull$$$0(13);
                }
                return list2;
            }
            if (list == null) {
                ExternalSystemEventSerializer.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static String filesToString(@NotNull List<String> files) {
        if (files == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(14);
        }
        String string = ExternalSystemEventSerializer.valuesToString(files, path -> Base64.getEncoder().encodeToString(path.getBytes(StandardCharsets.UTF_8)));
        if (string == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String errorsToString(@NotNull List<Integer> errors) {
        if (errors == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(16);
        }
        String string = ExternalSystemEventSerializer.valuesToString(errors, error -> String.valueOf(error));
        if (string == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static <V> String valuesToString(@NotNull List<? extends V> values, @NotNull Function<? super V, String> processor) {
        if (values == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            ExternalSystemEventSerializer.$$$reportNull$$$0(19);
        }
        return values.stream().map(processor).collect(Collectors.joining(",", "[", "]"));
    }

    private static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/uploader/events/ExternalSystemEventSerializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/uploader/events/ExternalSystemEventSerializer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValues";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "errorsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSentFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseErrors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseValues";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filesToString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "errorsToString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "valuesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

