/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.MessagePart;
import training.ui.OnboardingFeedbackFormKt;
import training.ui.StepAnimator;
import training.ui.UISettings;
import training.ui.views.LearnPanel;
import training.ui.views.LearnPanelKt;
import training.ui.views.LinkLabelWithBackArrow;
import training.util.OnboardingFeedbackData;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u001bJ\b\u0010%\u001a\u00020\u001bH\u0002J\u0006\u0010&\u001a\u00020\u001bJ\b\u0010'\u001a\u00020\u0001H\u0002J\u0010\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020\u0013H\u0002J\u0006\u00102\u001a\u00020\u001bJ\b\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0002J\u0006\u00106\u001a\u00020\u001bJ\u0006\u00107\u001a\u000204J\u000e\u00108\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*J\u000e\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u000204J\u000e\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u000204J\u000e\u0010=\u001a\u00020\u001b2\u0006\u0010:\u001a\u000204J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u000204H\u0002J\u0012\u0010@\u001a\u00020\u001b2\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\b\u0010C\u001a\u00020\u001bH\u0002J\u0006\u0010D\u001a\u00020\u001bJ\u0006\u0010E\u001a\u00020\u001bJ\u000e\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u000204J\b\u0010H\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Ltraining/ui/views/LearnPanel;", "Ljavax/swing/JPanel;", "learnToolWindow", "Ltraining/ui/LearnToolWindow;", "(Ltraining/ui/LearnToolWindow;)V", "getLearnToolWindow", "()Ltraining/ui/LearnToolWindow;", "lessonMessagePane", "Ltraining/ui/LessonMessagePane;", "getLessonMessagePane", "()Ltraining/ui/LessonMessagePane;", "lessonPanel", "lessonPanelBoxLayout", "Ljavax/swing/BoxLayout;", "nextButton", "Ljavax/swing/JButton;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "scrollToNewMessages", "", "getScrollToNewMessages$intellij_featuresTrainer", "()Z", "setScrollToNewMessages$intellij_featuresTrainer", "(Z)V", "stepAnimator", "Ltraining/ui/StepAnimator;", "addMessage", "", "text", "", "properties", "Ltraining/ui/LessonMessagePane$MessageProperties;", "addMessages", "messageParts", "", "Ltraining/ui/MessagePart;", "adjustMessagesArea", "clearMessages", "clearRestoreMessage", "createButtonsPanel", "createFooterPanel", "lesson", "Ltraining/learn/course/Lesson;", "createHeaderPanel", "Lcom/intellij/ui/components/panels/VerticalBox;", "createLessonNameLabel", "Ljavax/swing/JLabel;", "createNavigationButton", "targetLesson", "isNext", "focusCurrentMessage", "getVisibleAreaWidth", "", "initLessonPanel", "makeNextButtonSelected", "messagesNumber", "reinitMe", "removeInactiveMessages", "number", "removeMessage", "index", "resetMessagesNumber", "scrollTo", "needTo", "scrollToMessage", "needToShow", "Ljava/awt/Rectangle;", "scrollToTheEnd", "scrollToTheStart", "setPreviousMessagesPassed", "updatePanelSize", "viewAreaWidth", "useAnimation", "intellij.featuresTrainer"})
public final class LearnPanel
extends JPanel {
    private final JPanel lessonPanel;
    @NotNull
    private final LessonMessagePane lessonMessagePane;
    private JButton nextButton;
    private final JBScrollPane scrollPane;
    private final StepAnimator stepAnimator;
    private final BoxLayout lessonPanelBoxLayout;
    private boolean scrollToNewMessages;
    @NotNull
    private final LearnToolWindow learnToolWindow;

    @NotNull
    public final LessonMessagePane getLessonMessagePane() {
        return this.lessonMessagePane;
    }

    public final boolean getScrollToNewMessages$intellij_featuresTrainer() {
        return this.scrollToNewMessages;
    }

    public final void setScrollToNewMessages$intellij_featuresTrainer(boolean bl) {
        this.scrollToNewMessages = bl;
    }

    public final void reinitMe(@NotNull Lesson lesson) {
        UISettings uISettings;
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        UISettings $this$with = uISettings = UISettings.Companion.getInstance();
        boolean bl = false;
        this.setBorder(new EmptyBorder($this$with.getNorthInset(), 0, $this$with.getSouthInset(), 0));
        this.scrollToNewMessages = true;
        this.clearMessages();
        this.lessonPanel.removeAll();
        this.removeAll();
        this.add((Component)this.createHeaderPanel(lesson));
        this.add(LearnPanelKt.access$createSmallSeparator());
        this.add(UtilsKt.scaledRigid(UISettings.Companion.getInstance().getPanelWidth(), JBUI.scale((int)4)));
        this.initLessonPanel(lesson);
        this.scrollPane.setAlignmentX(0.0f);
        this.add((Component)this.scrollPane);
    }

    public final void updatePanelSize(int viewAreaWidth) {
        int n = UISettings.Companion.getInstance().getPanelWidth();
        int width = Math.max(n, viewAreaWidth) - 2 * UISettings.Companion.getInstance().getLearnPanelSideOffset();
        this.lessonMessagePane.setPreferredSize(null);
        this.lessonMessagePane.setBounds(0, 0, width, 10000);
        this.lessonMessagePane.revalidate();
        this.lessonMessagePane.repaint();
        this.lessonMessagePane.setPreferredSize(new Dimension(width, this.lessonMessagePane.getPreferredSize().height));
        this.lessonPanel.revalidate();
        this.lessonPanel.doLayout();
        this.lessonPanel.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createFooterPanel(Lesson lesson) {
        void it;
        JPanel shiftedFooter = new JPanel();
        shiftedFooter.setName("footerLessonPanel");
        shiftedFooter.setLayout(new BoxLayout(shiftedFooter, 1));
        shiftedFooter.setFocusable(false);
        shiftedFooter.setOpaque(false);
        shiftedFooter.setBorder(new MatteBorder(JBUI.scale((int)1), 0, 0, 0, UISettings.Companion.getInstance().getSeparatorColor()));
        JPanel footerContent = new JPanel();
        footerContent.setOpaque(false);
        footerContent.setLayout(new BoxLayout(footerContent, 1));
        footerContent.add(UtilsKt.rigid(0, 16));
        JLabel jLabel = new JLabel(IdeBundle.message((String)"welcome.screen.learnIde.help.and.resources.text", (Object[])new Object[0]));
        JLabel jLabel2 = jLabel;
        JPanel jPanel = footerContent;
        boolean $i$a$-also-LearnPanel$createFooterPanel$232 = false;
        it.setFont(UISettings.Companion.getInstance().getFont(1).deriveFont(1));
        Unit unit = Unit.INSTANCE;
        jPanel.add(jLabel);
        Map<String, String> $i$a$-also-LearnPanel$createFooterPanel$232 = lesson.getHelpLinks();
        for (Map.Entry entry : $i$a$-also-LearnPanel$createFooterPanel$232.entrySet()) {
            String text2 = (String)entry.getKey();
            String link = (String)entry.getValue();
            LinkLabel linkLabel2 = new LinkLabel(text2, null, new LinkListener(link, lesson){
                final /* synthetic */ String $link;
                final /* synthetic */ Lesson $lesson;

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    UtilsKt.openLinkInBrowser(this.$link);
                    StatisticBase.Companion.logHelpLinkClicked(this.$lesson.getId());
                }
                {
                    this.$link = string;
                    this.$lesson = lesson;
                }
            });
            footerContent.add(UtilsKt.rigid(0, 5));
            footerContent.add(UtilsKt.wrapWithUrlPanel((LinkLabel<Object>)linkLabel2));
        }
        shiftedFooter.add(footerContent);
        shiftedFooter.add(Box.createHorizontalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(shiftedFooter);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        return jPanel2;
    }

    private final void initLessonPanel(Lesson lesson) {
        this.lessonPanel.setName("lessonPanel");
        this.lessonPanel.setLayout(this.lessonPanelBoxLayout);
        this.lessonPanel.setFocusable(false);
        this.lessonPanel.setOpaque(true);
        Object object = UISettings.Companion.getInstance();
        UISettings $this$with = object;
        boolean bl = false;
        this.lessonPanel.setBackground($this$with.getBackgroundColor());
        this.lessonPanel.setBorder(new EmptyBorder(0, $this$with.getLearnPanelSideOffset(), 0, $this$with.getLearnPanelSideOffset()));
        this.lessonMessagePane.setName("lessonMessagePane");
        this.lessonMessagePane.setFocusable(false);
        this.lessonMessagePane.setOpaque(false);
        this.lessonMessagePane.setAlignmentX(0.0f);
        this.lessonMessagePane.setMargin((Insets)JBInsets.emptyInsets());
        this.lessonMessagePane.setBorder(new EmptyBorder(0, 0, JBUI.scale((int)20), JBUI.scale((int)14)));
        this.lessonPanel.add(UtilsKt.scaledRigid(UISettings.Companion.getInstance().getPanelWidth() - 2 * UISettings.Companion.getInstance().getLearnPanelSideOffset(), JBUI.scale((int)19)));
        this.lessonPanel.add(this.createLessonNameLabel(lesson));
        this.lessonPanel.add(this.lessonMessagePane);
        this.lessonPanel.add(this.createButtonsPanel());
        this.lessonPanel.add(Box.createVerticalGlue());
        object = lesson.getHelpLinks();
        if (!object.isEmpty() && Registry.is((String)"ift.help.links", (boolean)false)) {
            this.lessonPanel.add(UtilsKt.rigid(0, 16));
            this.lessonPanel.add(this.createFooterPanel(lesson));
        }
    }

    private final JLabel createLessonNameLabel(Lesson lesson) {
        JLabel lessonNameLabel = new JLabel();
        lessonNameLabel.setName("lessonNameLabel");
        lessonNameLabel.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        lessonNameLabel.setFont(UISettings.Companion.getInstance().getFont(5).deriveFont(1));
        lessonNameLabel.setAlignmentX(0.0f);
        lessonNameLabel.setFocusable(false);
        lessonNameLabel.setText(lesson.getName());
        lessonNameLabel.setForeground(UISettings.Companion.getInstance().getDefaultTextColor());
        return lessonNameLabel;
    }

    private final VerticalBox createHeaderPanel(Lesson lesson) {
        JLabel moduleNameLabel2 = (JLabel)((Object)new LinkLabelWithBackArrow(createHeaderPanel.moduleNameLabel.1.INSTANCE));
        moduleNameLabel2.setName("moduleNameLabel");
        moduleNameLabel2.setFont(UISettings.Companion.getInstance().getFont(1));
        moduleNameLabel2.setText("    " + lesson.getModule().getName());
        moduleNameLabel2.setForeground(UISettings.Companion.getInstance().getDefaultTextColor());
        moduleNameLabel2.setFocusable(false);
        JPanel linksPanel = new JPanel();
        linksPanel.setOpaque(false);
        linksPanel.setLayout(new BoxLayout(linksPanel, 0));
        linksPanel.setAlignmentX(0.0f);
        linksPanel.setBorder(new EmptyBorder(0, 0, JBUI.scale((int)12), 0));
        linksPanel.add(moduleNameLabel2);
        linksPanel.add(Box.createHorizontalGlue());
        JLabel exitLink = new JLabel(LearnBundle.INSTANCE.message("exit.learning.link", new Object[0]), AllIcons.Actions.Exit, 10);
        exitLink.setCursor(Cursor.getPredefinedCursor(12));
        exitLink.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LearnPanel this$0;

            public void mouseClicked(@NotNull MouseEvent e) {
                block3: {
                    Project project;
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (!StatisticBase.Companion.isLearnProjectCloseLogged()) {
                            StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.EXIT_LINK);
                        }
                        LessonManager.Companion.getInstance().stopLesson();
                        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
                        project = this.this$0.getLearnToolWindow().getProject();
                        Object object = langSupport2;
                        if (object != null && (object = object.getOnboardingFeedbackData()) != null) {
                            Object object2;
                            Object it = object2 = object;
                            boolean bl = false;
                            OnboardingFeedbackFormKt.showOnboardingLessonFeedbackForm(project, (OnboardingFeedbackData)it, false);
                            langSupport2.setOnboardingFeedbackData(null);
                        }
                        if (langSupport2 == null || !UtilsKt.isLearningProject(project, langSupport2)) break block2;
                        new CloseProjectWindowHelper().windowClosing(project);
                        break block3;
                    }
                    LearningUiManager.INSTANCE.resetModulesView();
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Learn");
                    if (toolWindow == null) break block3;
                    toolWindow.hide();
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        linksPanel.add(exitLink);
        VerticalBox headerPanel = new VerticalBox();
        headerPanel.setOpaque(false);
        headerPanel.setAlignmentX(0.0f);
        headerPanel.setBorder(UISettings.Companion.getInstance().getLessonHeaderBorder());
        headerPanel.add((Component)linksPanel);
        return headerPanel;
    }

    public final void addMessage(@Language(value="HTML") @NotNull String text2, @NotNull LessonMessagePane.MessageProperties properties) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        List<MessagePart> messages = MessageFactory.INSTANCE.convert(text2);
        MessageFactory.INSTANCE.setLinksHandlers(messages);
        this.addMessages(messages, properties);
    }

    public static /* synthetic */ void addMessage$default(LearnPanel learnPanel, String string, LessonMessagePane.MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new LessonMessagePane.MessageProperties(null, null, false, null, 15, null);
        }
        learnPanel.addMessage(string, messageProperties);
    }

    public final void addMessages(@NotNull List<MessagePart> messageParts, @NotNull LessonMessagePane.MessageProperties properties) {
        Intrinsics.checkNotNullParameter(messageParts, (String)"messageParts");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Function0<Rectangle> needToShow = this.lessonMessagePane.addMessage(messageParts, properties);
        this.adjustMessagesArea();
        if (properties.getState() != LessonMessagePane.MessageState.INACTIVE) {
            this.scrollToMessage((Rectangle)needToShow.invoke());
        }
    }

    public static /* synthetic */ void addMessages$default(LearnPanel learnPanel, List list2, LessonMessagePane.MessageProperties messageProperties, int n, Object object) {
        if ((n & 2) != 0) {
            messageProperties = new LessonMessagePane.MessageProperties(null, null, false, null, 15, null);
        }
        learnPanel.addMessages(list2, messageProperties);
    }

    public final void focusCurrentMessage() {
        this.scrollToMessage(this.lessonMessagePane.getCurrentMessageRectangle());
    }

    private final void scrollToMessage(Rectangle needToShow) {
        if (needToShow == null) {
            return;
        }
        if (this.scrollToNewMessages) {
            this.adjustMessagesArea();
            Rectangle rectangle = this.lessonPanel.getVisibleRect();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"lessonPanel.visibleRect");
            Dimension visibleSize = rectangle.getSize();
            int n = 0;
            int n2 = needToShow.y + this.lessonMessagePane.getLocation().y - visibleSize.height / 2 + needToShow.height / 2;
            int needToScroll = Math.max(n, n2);
            this.scrollTo(needToScroll);
        }
    }

    public final void adjustMessagesArea() {
        this.updatePanelSize(this.getVisibleAreaWidth());
        this.revalidate();
        this.repaint();
    }

    public final void resetMessagesNumber(int number) {
        Function0<Rectangle> needToShow = this.lessonMessagePane.resetMessagesNumber(number);
        this.adjustMessagesArea();
        this.scrollToMessage((Rectangle)needToShow.invoke());
    }

    public final void removeInactiveMessages(int number) {
        this.lessonMessagePane.removeInactiveMessages(number);
        this.adjustMessagesArea();
    }

    public final int messagesNumber() {
        return this.lessonMessagePane.messagesNumber();
    }

    public final void setPreviousMessagesPassed() {
        this.lessonMessagePane.passPreviousMessages();
        this.adjustMessagesArea();
    }

    private final void clearMessages() {
        this.lessonMessagePane.clear();
    }

    private final JPanel createButtonsPanel() {
        JButton jButton;
        JButton jButton2;
        Lesson it;
        Lesson previousLesson;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setName("buttonPanel");
        buttonPanel.setBorder(new EmptyBorder(0, UISettings.Companion.getInstance().getCheckIndent() - new JButton().getInsets().left, 0, 0));
        buttonPanel.setOpaque(false);
        buttonPanel.setFocusable(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setAlignmentX(0.0f);
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(null);
        }
        Lesson lesson = previousLesson = UtilsKt.getPreviousLessonForCurrent();
        if (lesson != null) {
            Lesson lesson2;
            it = lesson2 = lesson;
            boolean bl = false;
            jButton2 = this.createNavigationButton(previousLesson, false);
        } else {
            jButton2 = null;
        }
        JButton prevButton = jButton2;
        Lesson nextLesson = UtilsKt.getNextLessonForCurrent();
        LearnPanel learnPanel = this;
        Lesson lesson3 = nextLesson;
        if (lesson3 != null) {
            Lesson bl = it = lesson3;
            LearnPanel learnPanel2 = learnPanel;
            boolean bl2 = false;
            JButton jButton3 = this.createNavigationButton(nextLesson, true);
            learnPanel = learnPanel2;
            jButton = jButton3;
        } else {
            jButton = null;
        }
        learnPanel.nextButton = jButton;
        for (JButton button2 : CollectionsKt.listOfNotNull((Object[])new JButton[]{prevButton, this.nextButton})) {
            button2.setMargin((Insets)JBInsets.emptyInsets());
            button2.setFocusable(false);
            button2.setEnabled(true);
            button2.setOpaque(false);
            buttonPanel.add(button2);
        }
        return buttonPanel;
    }

    private final JButton createNavigationButton(Lesson targetLesson, boolean isNext) {
        JButton button2 = new JButton();
        button2.setAction(new AbstractAction(this, isNext, targetLesson){
            final /* synthetic */ LearnPanel this$0;
            final /* synthetic */ boolean $isNext;
            final /* synthetic */ Lesson $targetLesson;

            public void actionPerformed(@NotNull ActionEvent actionEvent) {
                Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"actionEvent");
                StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.OPEN_NEXT_OR_PREV_LESSON);
                LessonStartingWay startingWay = this.$isNext ? LessonStartingWay.NEXT_BUTTON : LessonStartingWay.PREV_BUTTON;
                CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.this$0.getLearnToolWindow().getProject(), this.$targetLesson, startingWay, false, false, 24, null);
            }
            {
                this.this$0 = this$0;
                this.$isNext = $captured_local_variable$1;
                this.$targetLesson = $captured_local_variable$2;
            }
        });
        button2.setText(isNext ? LearnBundle.INSTANCE.message("learn.new.ui.button.next", targetLesson.getName()) : LearnBundle.INSTANCE.message("learn.new.ui.button.back", new Object[0]));
        button2.updateUI();
        button2.setSelected(true);
        if (!targetLesson.getPassed$intellij_featuresTrainer() && !targetLesson.getProperties().getCanStartInDumbMode()) {
            DumbService dumbService = DumbService.getInstance((Project)this.learnToolWindow.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(learnToolWindow.project)");
            if (dumbService.isDumb()) {
                button2.setEnabled(false);
                button2.setToolTipText(LearnBundle.INSTANCE.message("indexing.message", new Object[0]));
                button2.setSelected(false);
                DumbService.getInstance((Project)this.learnToolWindow.getProject()).runWhenSmart(new Runnable(button2){
                    final /* synthetic */ JButton $button;

                    public final void run() {
                        this.$button.setEnabled(true);
                        this.$button.setToolTipText("");
                        this.$button.setSelected(true);
                    }
                    {
                        this.$button = jButton;
                    }
                });
            }
        }
        return button2;
    }

    public final void makeNextButtonSelected() {
        JButton jButton = this.nextButton;
        if (jButton != null) {
            JButton jButton2;
            JButton it = jButton2 = jButton;
            boolean bl = false;
            JRootPane jRootPane = this.getRootPane();
            if (jRootPane != null) {
                jRootPane.setDefaultButton(it);
            }
            it.setSelected(true);
            it.setFocusable(true);
            it.requestFocus();
        }
        if (this.scrollToNewMessages) {
            this.adjustMessagesArea();
            this.scrollToTheEnd();
        }
    }

    public final void clearRestoreMessage() {
        Function0<Rectangle> needToShow = this.lessonMessagePane.clearRestoreMessages();
        this.scrollToMessage((Rectangle)needToShow.invoke());
    }

    public final void removeMessage(int index) {
        this.lessonMessagePane.removeMessage(index);
    }

    private final int getVisibleAreaWidth() {
        Serializable serializable = this.scrollPane.getVerticalScrollBar();
        int scrollWidth = serializable != null && (serializable = serializable.getSize()) != null ? ((Dimension)serializable).width : 0;
        JViewport jViewport = this.scrollPane.getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"scrollPane.viewport");
        return jViewport.getExtentSize().width - scrollWidth;
    }

    private final void scrollToTheEnd() {
        JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
        if (this.useAnimation()) {
            JScrollBar jScrollBar = vertical;
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"vertical");
            this.stepAnimator.startAnimation(jScrollBar.getMaximum());
        } else {
            JScrollBar jScrollBar = vertical;
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"vertical");
            jScrollBar.setValue(vertical.getMaximum());
        }
    }

    public final void scrollToTheStart() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
        jScrollBar.setValue(0);
    }

    private final void scrollTo(int needTo) {
        if (this.useAnimation()) {
            this.stepAnimator.startAnimation(needTo);
        } else {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
            jScrollBar.setValue(needTo);
        }
    }

    private final boolean useAnimation() {
        return Registry.is((String)"ift.use.scroll.animation", (boolean)false);
    }

    @NotNull
    public final LearnToolWindow getLearnToolWindow() {
        return this.learnToolWindow;
    }

    public LearnPanel(@NotNull LearnToolWindow learnToolWindow) {
        Intrinsics.checkNotNullParameter((Object)((Object)learnToolWindow), (String)"learnToolWindow");
        this.learnToolWindow = learnToolWindow;
        this.lessonPanel = new JPanel();
        this.lessonMessagePane = new LessonMessagePane(false, 1, null);
        this.scrollPane = new JBScrollPane((Component)this.lessonPanel);
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"scrollPane.verticalScrollBar");
        this.stepAnimator = new StepAnimator(jScrollBar, this.lessonMessagePane);
        this.lessonPanelBoxLayout = new BoxLayout(this.lessonPanel, 1);
        this.scrollToNewMessages = true;
        Disposer.register((Disposable)this.learnToolWindow.getParentDisposable$intellij_featuresTrainer(), (Disposable)this.lessonMessagePane);
        this.setFocusable(false);
        this.setBackground(UISettings.Companion.getInstance().getBackgroundColor());
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(true);
        this.scrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.updatePanelSize(this.getVisibleAreaWidth());
            }
        });
    }
}

