/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(ivec2(-5, -5), ivec2(-5, -2)) => bvec2(true, false)
 * equal(ivec2(-5, -5), ivec2(-1, 0)) => bvec2(false, false)
 * equal(ivec2(-5, -5), ivec2(1, 2)) => bvec2(false, false)
 * equal(ivec2(-5, -2), ivec2(5, -5)) => bvec2(false, false)
 * equal(ivec2(-2, -2), ivec2(-2, -1)) => bvec2(true, false)
 * equal(ivec2(-2, -2), ivec2(0, 1)) => bvec2(false, false)
 * equal(ivec2(-2, -2), ivec2(2, 5)) => bvec2(false, false)
 * equal(ivec2(-1, -1), ivec2(-5, -2)) => bvec2(false, false)
 * equal(ivec2(-1, -1), ivec2(-1, 0)) => bvec2(true, false)
 * equal(ivec2(-1, -1), ivec2(1, 2)) => bvec2(false, false)
 * equal(ivec2(-1, 0), ivec2(5, -5)) => bvec2(false, false)
 * equal(ivec2(0, 0), ivec2(-2, -1)) => bvec2(false, false)
 * equal(ivec2(0, 0), ivec2(0, 1)) => bvec2(true, false)
 * equal(ivec2(0, 0), ivec2(2, 5)) => bvec2(false, false)
 * equal(ivec2(1, 1), ivec2(-5, -2)) => bvec2(false, false)
 * equal(ivec2(1, 1), ivec2(-1, 0)) => bvec2(false, false)
 * equal(ivec2(1, 1), ivec2(1, 2)) => bvec2(true, false)
 * equal(ivec2(1, 2), ivec2(5, -5)) => bvec2(false, false)
 * equal(ivec2(2, 2), ivec2(-2, -1)) => bvec2(false, false)
 * equal(ivec2(2, 2), ivec2(0, 1)) => bvec2(false, false)
 * equal(ivec2(2, 2), ivec2(2, 5)) => bvec2(true, false)
 * equal(ivec2(5, 5), ivec2(-5, -2)) => bvec2(false, false)
 * equal(ivec2(5, 5), ivec2(-1, 0)) => bvec2(false, false)
 * equal(ivec2(5, 5), ivec2(1, 2)) => bvec2(false, false)
 * equal(ivec2(5, -5), ivec2(5, -5)) => bvec2(true, true)
 */
#version 120

void main()
{
  float[equal(ivec2(-5, -5), ivec2(-5, -2))[0] == true && equal(ivec2(-5, -5), ivec2(-5, -2))[1] == false ? 1 : -1] array0;
  float[equal(ivec2(-5, -5), ivec2(-1, 0))[0] == false && equal(ivec2(-5, -5), ivec2(-1, 0))[1] == false ? 1 : -1] array1;
  float[equal(ivec2(-5, -5), ivec2(1, 2))[0] == false && equal(ivec2(-5, -5), ivec2(1, 2))[1] == false ? 1 : -1] array2;
  float[equal(ivec2(-5, -2), ivec2(5, -5))[0] == false && equal(ivec2(-5, -2), ivec2(5, -5))[1] == false ? 1 : -1] array3;
  float[equal(ivec2(-2, -2), ivec2(-2, -1))[0] == true && equal(ivec2(-2, -2), ivec2(-2, -1))[1] == false ? 1 : -1] array4;
  float[equal(ivec2(-2, -2), ivec2(0, 1))[0] == false && equal(ivec2(-2, -2), ivec2(0, 1))[1] == false ? 1 : -1] array5;
  float[equal(ivec2(-2, -2), ivec2(2, 5))[0] == false && equal(ivec2(-2, -2), ivec2(2, 5))[1] == false ? 1 : -1] array6;
  float[equal(ivec2(-1, -1), ivec2(-5, -2))[0] == false && equal(ivec2(-1, -1), ivec2(-5, -2))[1] == false ? 1 : -1] array7;
  float[equal(ivec2(-1, -1), ivec2(-1, 0))[0] == true && equal(ivec2(-1, -1), ivec2(-1, 0))[1] == false ? 1 : -1] array8;
  float[equal(ivec2(-1, -1), ivec2(1, 2))[0] == false && equal(ivec2(-1, -1), ivec2(1, 2))[1] == false ? 1 : -1] array9;
  float[equal(ivec2(-1, 0), ivec2(5, -5))[0] == false && equal(ivec2(-1, 0), ivec2(5, -5))[1] == false ? 1 : -1] array10;
  float[equal(ivec2(0, 0), ivec2(-2, -1))[0] == false && equal(ivec2(0, 0), ivec2(-2, -1))[1] == false ? 1 : -1] array11;
  float[equal(ivec2(0, 0), ivec2(0, 1))[0] == true && equal(ivec2(0, 0), ivec2(0, 1))[1] == false ? 1 : -1] array12;
  float[equal(ivec2(0, 0), ivec2(2, 5))[0] == false && equal(ivec2(0, 0), ivec2(2, 5))[1] == false ? 1 : -1] array13;
  float[equal(ivec2(1, 1), ivec2(-5, -2))[0] == false && equal(ivec2(1, 1), ivec2(-5, -2))[1] == false ? 1 : -1] array14;
  float[equal(ivec2(1, 1), ivec2(-1, 0))[0] == false && equal(ivec2(1, 1), ivec2(-1, 0))[1] == false ? 1 : -1] array15;
  float[equal(ivec2(1, 1), ivec2(1, 2))[0] == true && equal(ivec2(1, 1), ivec2(1, 2))[1] == false ? 1 : -1] array16;
  float[equal(ivec2(1, 2), ivec2(5, -5))[0] == false && equal(ivec2(1, 2), ivec2(5, -5))[1] == false ? 1 : -1] array17;
  float[equal(ivec2(2, 2), ivec2(-2, -1))[0] == false && equal(ivec2(2, 2), ivec2(-2, -1))[1] == false ? 1 : -1] array18;
  float[equal(ivec2(2, 2), ivec2(0, 1))[0] == false && equal(ivec2(2, 2), ivec2(0, 1))[1] == false ? 1 : -1] array19;
  float[equal(ivec2(2, 2), ivec2(2, 5))[0] == true && equal(ivec2(2, 2), ivec2(2, 5))[1] == false ? 1 : -1] array20;
  float[equal(ivec2(5, 5), ivec2(-5, -2))[0] == false && equal(ivec2(5, 5), ivec2(-5, -2))[1] == false ? 1 : -1] array21;
  float[equal(ivec2(5, 5), ivec2(-1, 0))[0] == false && equal(ivec2(5, 5), ivec2(-1, 0))[1] == false ? 1 : -1] array22;
  float[equal(ivec2(5, 5), ivec2(1, 2))[0] == false && equal(ivec2(5, 5), ivec2(1, 2))[1] == false ? 1 : -1] array23;
  float[equal(ivec2(5, -5), ivec2(5, -5))[0] == true && equal(ivec2(5, -5), ivec2(5, -5))[1] == true ? 1 : -1] array24;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length());
}
