/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class SingleBridgeSelectionStrategy
extends BridgeSelectionStrategy {
    private static final Logger logger = new LoggerImpl(SingleBridgeSelectionStrategy.class.getName());

    @Override
    public Bridge doSelect(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        if (conferenceBridges.size() == 0) {
            return this.leastLoadedInRegion(bridges, Collections.emptyMap(), participantRegion).orElseGet(() -> this.leastLoaded(bridges, Collections.emptyMap(), participantRegion).orElse(null));
        }
        if (conferenceBridges.size() != 1) {
            logger.error("Unexpected number of bridges with SingleBridgeSelectionStrategy: " + conferenceBridges.size());
            return null;
        }
        Bridge bridge2 = (Bridge)conferenceBridges.keySet().stream().findFirst().get();
        if (!bridge2.isOperational()) {
            logger.error("The conference already has a bridge, but it is not operational: bridge=" + bridge2);
            return null;
        }
        return bridge2;
    }
}

