/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class KotlinImplementerDefaultInterfaceMemberFilter
extends MethodVisitingFilter {
    private byte matchedInstructions = 0;
    private int myLine = -1;
    private LineData myPreviousLineData;
    private State myState;
    private int myLoadArgsNumber;
    private int myLoadArgIndex;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context) && context.hasInterfaces();
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        super.initFilter(methodVisitor, context, name, desc);
        this.myState = State.UNKNOWN;
        this.myLoadArgsNumber = Type.getArgumentTypes(desc).length + 1;
        this.myLoadArgIndex = 0;
    }

    private boolean completed() {
        return this.myState != State.UNKNOWN;
    }

    private void filter() {
        if (this.myPreviousLineData == null) {
            this.myContext.removeLine(this.myLine);
        }
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 0) {
            this.matchedInstructions = 1;
        } else if (this.matchedInstructions == 5) {
            this.myState = State.SHOULD_NOT_COVER;
            this.filter();
        } else {
            this.myState = State.SHOULD_COVER;
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.myPreviousLineData = this.myContext.getLineData(line);
        super.visitLineNumber(line, start);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 1) {
            this.matchedInstructions = (byte)2;
            this.myLine = line;
        } else {
            this.myState = State.SHOULD_COVER;
        }
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 2 && KotlinImplementerDefaultInterfaceMemberFilter.isLoadOpcode(opcode) && var == this.myLoadArgIndex) {
            ++this.myLoadArgIndex;
            if (this.myLoadArgIndex == this.myLoadArgsNumber) {
                this.matchedInstructions = (byte)3;
            }
        } else {
            this.myState = State.SHOULD_COVER;
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 3 && owner.endsWith("$DefaultImpls")) {
            this.matchedInstructions = (byte)4;
        } else {
            this.myState = State.SHOULD_COVER;
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.completed()) {
            return;
        }
        if (this.matchedInstructions == 4 && opcode == 177) {
            this.matchedInstructions = (byte)5;
        } else {
            this.myState = State.SHOULD_COVER;
        }
    }

    private static boolean isLoadOpcode(int opcode) {
        return 21 <= opcode && opcode <= 53;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SHOULD_COVER,
        SHOULD_NOT_COVER,
        UNKNOWN;

    }
}

