/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.data.instructions.JumpInstructions;
import com.intellij.rt.coverage.data.instructions.SwitchInstructions;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineInstructions {
    private int myInstructions;
    private List<JumpInstructions> myJumps;
    private List<SwitchInstructions> mySwitches;

    public void setInstructions(int instructions) {
        this.myInstructions = instructions;
    }

    public void addJump(JumpInstructions jump) {
        if (this.myJumps == null) {
            this.myJumps = new ArrayList<JumpInstructions>();
        }
        this.myJumps.add(jump);
    }

    public void addSwitch(SwitchInstructions aSwitch) {
        if (this.mySwitches == null) {
            this.mySwitches = new ArrayList<SwitchInstructions>();
        }
        this.mySwitches.add(aSwitch);
    }

    public int getInstructions() {
        return this.myInstructions;
    }

    public List<JumpInstructions> getJumps() {
        return this.myJumps;
    }

    public List<SwitchInstructions> getSwitches() {
        return this.mySwitches;
    }

    public void merge(LineInstructions other) {
        int i;
        this.myInstructions = Math.max(this.myInstructions, other.myInstructions);
        if (other.myJumps != null) {
            if (this.myJumps == null) {
                this.myJumps = new ArrayList<JumpInstructions>();
            }
            for (i = this.myJumps.size(); i < other.myJumps.size(); ++i) {
                this.myJumps.add(new JumpInstructions());
            }
            for (i = 0; i < other.myJumps.size(); ++i) {
                this.myJumps.get(i).merge(other.myJumps.get(i));
            }
        }
        if (other.mySwitches != null) {
            if (this.mySwitches == null) {
                this.mySwitches = new ArrayList<SwitchInstructions>();
            }
            for (i = this.mySwitches.size(); i < other.mySwitches.size(); ++i) {
                this.mySwitches.add(new SwitchInstructions(other.mySwitches.get(i).size()));
            }
            for (i = 0; i < other.mySwitches.size(); ++i) {
                this.mySwitches.get(i).merge(other.mySwitches.get(i));
            }
        }
    }

    public BranchData getInstructionsData(LineData line) {
        SwitchData[] switches;
        JumpData[] jumps;
        int total = 0;
        int covered = 0;
        total += this.myInstructions;
        if (line.getHits() > 0) {
            covered += this.myInstructions;
        }
        if ((jumps = line.getJumps()) != null && this.myJumps != null) {
            for (int i = 0; i < Math.min(jumps.length, this.myJumps.size()); ++i) {
                JumpData jump = jumps[i];
                JumpInstructions jumpInstructions = this.myJumps.get(i);
                total += jumpInstructions.getInstructions(true) + jumpInstructions.getInstructions(false);
                if (jump.getTrueHits() > 0) {
                    covered += jumpInstructions.getInstructions(true);
                }
                if (jump.getFalseHits() <= 0) continue;
                covered += jumpInstructions.getInstructions(false);
            }
        }
        if ((switches = line.getSwitches()) != null && this.mySwitches != null) {
            for (int i = 0; i < Math.min(switches.length, this.mySwitches.size()); ++i) {
                SwitchData switchData = switches[i];
                SwitchInstructions switchInstructions = this.mySwitches.get(i);
                total += switchInstructions.getInstructions(-1);
                if (switchData.getDefaultHits() > 0) {
                    covered += switchInstructions.getInstructions(-1);
                }
                for (int key = 0; key < switchData.getKeys().length; ++key) {
                    total += switchInstructions.getInstructions(key);
                    if (switchData.getHits()[key] <= 0) continue;
                    covered += switchInstructions.getInstructions(key);
                }
            }
        }
        return new BranchData(total, covered);
    }
}

