/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class FormPackageReference
extends ReferenceInForm {
    protected FormPackageReference(PsiPlainTextFile file, TextRange range) {
        super(file, range);
    }

    public PsiElement resolve() {
        Project project = this.myFile.getProject();
        String text = this.getRangeText().replace('/', '.');
        return JavaPsiFacade.getInstance((Project)project).findPackage(text);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            FormPackageReference.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiPackage)) {
            return false;
        }
        String qName = ((PsiPackage)element).getQualifiedName().replace('.', '/');
        String rangeText = this.getRangeText();
        return qName.equals(rangeText);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) {
        String s;
        int pos;
        if (newElementName == null) {
            FormPackageReference.$$$reportNull$$$0(1);
        }
        if ((pos = (s = this.getRangeText()).lastIndexOf("/")) < 0) {
            this.updateRangeText(newElementName);
        } else {
            this.updateRangeText(s.substring(0, pos + 1) + newElementName);
        }
        return this.myFile;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            FormPackageReference.$$$reportNull$$$0(2);
        }
        return this.myFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/binding/FormPackageReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleElementRename";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

