/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.util;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MyPsiUtil {
    private static final Logger LOG = Logger.getInstance(MyPsiUtil.class);

    private MyPsiUtil() {
    }

    @Nullable
    public static XmlElement findContextNode(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        PsiElement contextNode;
        if (psiFile == null) {
            MyPsiUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            MyPsiUtil.$$$reportNull$$$0(1);
        }
        for (contextNode = psiFile.findElementAt(editor.getCaretModel().getOffset()); contextNode != null && !MyPsiUtil.isValidContextNode(contextNode); contextNode = contextNode.getParent()) {
        }
        assert (contextNode == null || contextNode instanceof XmlElement);
        return (XmlElement)contextNode;
    }

    public static boolean isValidContextNode(@Nullable PsiElement contextNode) {
        return contextNode instanceof XmlTag || contextNode instanceof XmlDocument;
    }

    @NotNull
    public static PsiElement getNameElement(@NotNull XmlTag tag) {
        PsiElement element;
        if (tag == null) {
            MyPsiUtil.$$$reportNull$$$0(2);
        }
        if ((element = MyPsiUtil.findNameElement(tag)) != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                MyPsiUtil.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        LOG.error("Name element not found for " + tag);
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            MyPsiUtil.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    @Nullable
    public static PsiElement findNameElement(@NotNull XmlTag tag) {
        PsiElement[] children;
        if (tag == null) {
            MyPsiUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement child : children = tag.getChildren()) {
            if (!MyPsiUtil.isNameElement(child)) continue;
            return child;
        }
        return null;
    }

    public static boolean isNameElement(@Nullable PsiElement child) {
        if (child != null && child.getParent() instanceof XmlTag) {
            if (child instanceof XmlToken) {
                if (((XmlToken)child).getTokenType() == XmlTokenType.XML_NAME) {
                    return true;
                }
            } else if (child instanceof ASTNode) {
                return ((ASTNode)child).getElementType() == XmlTokenType.XML_NAME;
            }
        }
        return false;
    }

    public static String getAttributePrefix(@NotNull XmlAttribute attribute) {
        String name;
        if (attribute == null) {
            MyPsiUtil.$$$reportNull$$$0(6);
        }
        if ((name = attribute.getName()).indexOf(58) == -1) {
            return "";
        }
        return name.substring(0, name.indexOf(58));
    }

    public static boolean isStartTag(PsiElement contextNode) {
        if (contextNode instanceof PsiWhiteSpace) {
            PsiElement sibling;
            for (sibling = contextNode.getPrevSibling(); sibling != null && !MyPsiUtil.isNameElement(sibling); sibling = sibling.getPrevSibling()) {
            }
            return sibling != null;
        }
        if (contextNode instanceof XmlToken) {
            if (((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_START_TAG_START) {
                return true;
            }
            if (((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_TAG_END) {
                return true;
            }
            if (((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEndTag(PsiElement contextNode) {
        if (contextNode instanceof PsiWhiteSpace) {
            PsiElement sibling;
            for (sibling = contextNode.getPrevSibling(); sibling != null && !MyPsiUtil.isNameElement(sibling); sibling = sibling.getPrevSibling()) {
            }
            return sibling != null;
        }
        return contextNode instanceof XmlToken && ((XmlToken)contextNode).getTokenType() == XmlTokenType.XML_END_TAG_START;
    }

    public static boolean isInDeclaredNamespace(XmlTag context, String nsUri, String nsPrefix) {
        if (nsUri == null || nsUri.length() == 0 || nsPrefix != null && nsPrefix.length() > 0) {
            return true;
        }
        do {
            if (!context.getLocalNamespaceDeclarations().containsValue(nsUri)) continue;
            return true;
        } while ((context = (XmlTag)(context.getParent() instanceof XmlTag ? context.getParent() : null)) != null);
        return false;
    }

    public static String checkFile(final PsiFile file) {
        final String[] error = new String[1];
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                error[0] = element.getErrorDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/xpathView/util/MyPsiUtil$1", "visitErrorElement"));
            }
        });
        if (error[0] != null) {
            return error[0];
        }
        final Annotator annotator = (Annotator)LanguageAnnotators.INSTANCE.forLanguage(file.getLanguage());
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                AnnotationHolderImpl holder = new AnnotationHolderImpl(new AnnotationSession(file), false);
                holder.runAnnotatorWithContext(element, annotator);
                for (Annotation annotation : holder) {
                    if (annotation.getSeverity() != HighlightSeverity.ERROR) continue;
                    error[0] = annotation.getMessage();
                    break;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/xpathView/util/MyPsiUtil$2", "visitElement"));
            }
        });
        return error[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xpathView/util/MyPsiUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xpathView/util/MyPsiUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContextNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNameElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findNameElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

